% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matlog.R
\name{matlog}
\alias{matlog}
\title{Matrix Logarithm}
\usage{
matlog(A, ...)
}
\arguments{
\item{A}{a square matrix, real or complex.}

\item{...}{arguments passed to or from other methods.}
}
\value{
The matrix logarithm of A. Method used may be chosen from the options available in \code{logm}.
}
\description{
\code{matlog} computes the (principal) matrix logarithm of a square matrix.
}
\details{
This function adapts function \code{logm} from package \pkg{expm}
to be able to handle complex matrices, by decomposing the original matrix
into real and purely imaginary matrices and creating a real
block matrix that function \code{logm} can successfully process.
If the original matrix is real, \code{matlog} calls \code{logm} directly for maximum efficiency.
Hence, for real matrices, \code{matlog} can compute the matrix logarithm in the same instances as \code{logm};
for complex matrices, \code{matlog} can compute the matrix logarithm as long as all real
eigenvalues are positive: zero eigenvalues imply singularity (and therefore the log
does not exist) and negative eigenvalues can be problematic as it may be hard and
numerically unstable to calculate Jordan blocks. See references below.
}
\examples{
A <- matrix(c(1, 2, 2+3i, 5), ncol = 2)  # complex matrix
B <- matrix(c(2, 0, 3, 4), ncol = 2)  # real matrix with positive eigenvalues

matlog(A)
matlog(A, "Eigen")  # uses Eigen method in function logm
matlog(B)
matlog(B, "Eigen")  # uses Eigen method in function logm

}
\author{
Albert Dorador
}
\references{
For more on the matrix logarithm, visit
\url{https://en.wikipedia.org/wiki/Logarithm_of_a_matrix}
}
\seealso{
\code{\link[expm]{logm}}
}

