% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composite_tsout_ensemble.R
\name{comp_tsout_ens}
\alias{comp_tsout_ens}
\title{Performs composite time series outlier ensembling.}
\usage{
comp_tsout_ens(
  x,
  m1 = NULL,
  ncomp = 2,
  sds = 1,
  rept = 1,
  compr = 2,
  rat = 0.05,
  fast = TRUE
)
}
\arguments{
\item{x}{A  data frame or a matrix object containing a multivariate time series}

\item{m1}{Variable indicating dimension reduction methods. Default is set to using all 4 methods: PCA, DOBIN, ICS and ICA.}

\item{ncomp}{The number of components for each dimension reduction method. Default is set to 2.}

\item{sds}{The random seed for generating a no-outlier time series.}

\item{rept}{The number of repetitions for generating a no-outlier time series.}

\item{compr}{To adjust for multiple testing, the results of the ensemble are compared with the results of a time series without outliers. If \code{compr =1}, a time series is simulated as in \code{simulate_comp_ts} without outliers. If \code{compr = 2}, the top outliers are removed from the outlier series and interpolated values are used for those time points. If \code{compr = 3} both methods of simulation are used for comparison.}

\item{rat}{A comparison is done with the outliers removed time series. The variable \code{rat} denotes the ratio of outliers to be removed as a proportion of the whole dataset for this comparison.}

\item{fast}{For faster computation skip ICS decomposition method.}
}
\value{
A list with the following components:
\item{\code{outliers}}{The outliers detected from the multivariate ensemble after comparing with the comparison time series without outliers. }
\item{\code{all}}{All the outliers detected from the multivariate ensemble. }
\item{\code{outmat}}{A matrix with outlier scores organised by outlier method.}
\item{\code{wts}}{The weights of the outlier detection methods.}
\item{\code{pca_loadings}}{The basis vectors from PCA.}
\item{\code{dobin_loadings}}{The basis vectors from DOBIN. See R package \code{dobin} for more details.}
\item{\code{ics_loadings}}{The basis vectors from ICS. See R package \code{ICS} for more details.}
\item{\code{ica_loadings}}{The basis vectors from Independent Component Analysis.}
\item{\code{decomp_wts}}{Each decomposition method has several components. For example if \code{ncomp}=2, then there are 2 PC components, 2 DOBIn components, etc ... The weight of each component is given different and depends on the decomposition method. These weights are given in \code{decomp_wts}.}
\item{\code{outmat4D}}{A 4D array with outlier scores organised by outlier method, decomposition method, components for each decomposition method and time.}
 \item{\code{comp_loadings}}{The unconstrained basis vectors on the simplex.}
 \item{\code{comp_coords}}{The unconstrained coordinates of the composite time series data.}
}
\description{
Performs composite time series outlier ensembling.
}
\examples{
\donttest{
set.seed(100)
n <- 600
x <- sample(1:100, n, replace=TRUE)
x[25] <- 200
x[320] <- 300
x2 <- sample(1:100, n, replace=TRUE)
x3 <- sample(1:100, n, replace=TRUE)
x4 <- sample(1:100, n, replace=TRUE)
X <- cbind.data.frame(x, x2, x3, x4)
X <- X/rowSums(X)
out <- comp_tsout_ens(X, compr=2, fast=FALSE)
}

}
