% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorize.R
\name{cs_crime_cat}
\alias{cs_crime_cat}
\title{Categorize Crime}
\usage{
cs_crime_cat(.data, var, newVar, output)
}
\arguments{
\item{.data}{A tibble or data frame}

\item{var}{Name of variable with 5 or 6 digit crime codes}

\item{newVar}{Name of output variable to be created with simplified categories}

\item{output}{Type of output - either \code{"string"}, \code{"factor"}, or \code{"numeric"}.
If \code{"numeric"} is selected, the general UCR code will be returned (i.e. \code{1} for
homicide, \code{3} for aggravated assault, etc.). Factor output will be returned in order
of descending UCR code (i.e. beginning with homicide, which has a UCR code of \code{1}).}
}
\value{
A copy of the object with the new output variable appended to it.
}
\description{
The SLMPD data contains 5 or 6 digit codes to refer to
    specific categories of crime. \code{cs_crime_cat} transforms these
    into either string, factor, or simplified numeric categories
    like "murder" or "aggravated assault". This can be used
    on any police department's data where codes like \code{31111} (robbery with a firearm)
    or \code{142320} (malicious destruction of property) are used to identify crimes.
}
\details{
The categories used here are derived from the U.S. Federal
    Bureau of Investigation's Uniform Crime Reporting codes.
}
\examples{
# load example data
testData <- january2018

# apply categories
testData <- cs_crime_cat(testData,var = crime, newVar = crimeCat, output = "numeric")

# preview categories
table(testData$crimeCat)

# apply categories
testData <- cs_crime_cat(testData,var = crime, newVar = crimeCat, output = "factor")

# preview categories
table(testData$crimeCat)

# apply categories
testData <- cs_crime_cat(testData,var = crime, newVar = crimeCat, output = "string")

# preview categories
table(testData$crimeCat)

}
