% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{cs_standardize}
\alias{cs_standardize}
\title{Standardized Variables}
\usage{
cs_standardize(.data, month, config = 18)
}
\arguments{
\item{.data}{A tbl}

\item{month}{An option string name or abbreviation of a month, or its numeric value.
Acceptable inputs include, for example, "January", "january", "Jan",
"jan", and 1. If all months in a year-list need to be standardized (this is
applicable, as of March 2019, to all years from 2008 through 2012), the
month should be given as \code{"all"} to standardize them en masse.}

\item{config}{The non-standard configuration, either 18 or 26}
}
\description{
Different time points of SLMPD have different numbers of variables and
   different names for those variables that are included in both sets of releases.
   This function reformats non-standard configurations to a 20 variable standard.
}
\details{
For all months prior to 2013 and approximately half of the months during
   2013, SLMPD data are released with 18 variables. For one month, May 2017,
   the data are released with 26 variables. This function can be used to either
   edit an entire year list object or to edit only a specified month within it.
   In general, years 2008 through 2012 should be edited en masse while the month
   specification can be used to edit the months in 2013 and 2017 that are
   non-standard.
}
\examples{
# load example year-list object
load(system.file("testdata", "yearList17.rda", package = "compstatr", mustWork = TRUE))

# validate
cs_validate(yearList17, year = 2017)

# standaridze May, which has 26 variables
yearList17 <- cs_standardize(yearList17, month = "May", config = 26)

# validate again to confirm fix
cs_validate(yearList17, year = 2017)

}
