% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concom.R
\name{concom3d}
\alias{concom3d}
\title{Connected components of a 'rgl' mesh}
\usage{
concom3d(tmesh)
}
\arguments{
\item{tmesh}{a triangular \strong{rgl} mesh (of class \strong{mesh3d})}
}
\value{
A list of \strong{rgl} meshes, each one corresponding to a 
  connected component.
}
\description{
Computes the connected components of a triangular 'rgl' mesh.
}
\examples{
library(concom)
library(rgl)
library(rmarchingcubes)

# credit to 'ICN5D' for this isosurface 
f <- function(x, y, z, a, cosb, sinb){
    (sqrt((sqrt(x*x + (y*sinb + a*cosb)^2) - 2)^2) - 1)^2 +
      (sqrt((sqrt(z*z + (y*cosb - a*sinb)^2) - 2)^2) - 1)^2
}
a <- 0.6
b <- 0.785
cosb <- cos(b)
sinb <- sin(b)

\donttest{
x <- z <- seq(-3.5, 3.5, len = 150L)
y <- seq(-4.2, 4.2, len = 150L)
g <- expand.grid(X = x, Y = y, Z = z)
voxel <- array(
  with(g, f(X, Y, Z, a, cosb, sinb)),
  dim = c(150L, 150L, 150L)
)

contour_shape <- contour3d(
  griddata = voxel,
  level = 0.1,
  x = x,
  y = y,
  z = z
)

tmesh <- tmesh3d(
  vertices = t(contour_shape[["vertices"]]),
  indices = t(contour_shape[["triangles"]]),
  normals = contour_shape[["normals"]],
  homogeneous = FALSE
)

components <- concom3d(tmesh)
colors <- hcl.colors(length(components))
open3d(windowRect = c(50, 50, 562, 562), zoom = 0.9)
lapply(1:length(components), function(i){
  shade3d(components[[i]], color = colors[i])
})
}
}
