% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csCompare.R
\name{csCompare}
\alias{csCompare}
\title{Statistically compare CRs towards two CSs}
\usage{
csCompare(
  cs1,
  cs2,
  group = NULL,
  data = NULL,
  alternative = "two.sided",
  conf.level = 0.95,
  mu = 0,
  rscale = 0.707,
  descriptives = TRUE,
  out.thres = 3,
  boxplot = TRUE
)
}
\arguments{
\item{cs1}{a numeric vector of values. If the \code{data} argument is
defined, it can refer to either the column index or the column name of
the data object. See \code{Details} for more information.}

\item{cs2}{a numeric vector of values. If the \code{data} argument is
defined, it can refer to either the column index or the column name of
the data object. See \code{Details} for more information.}

\item{group}{column index or name that contain the group data. See
\code{Details} for more information.}

\item{data}{numeric matrix or data frame that contains the relevant data.}

\item{alternative}{a character string for the specification of
the alternative hypothesis. Possible values: \code{"two.sided"} (default),
\code{"greater"} or \code{"less"}.}

\item{conf.level}{Interval's confidence level.}

\item{mu}{a numeric value for the mean value or mean difference.}

\item{rscale}{the scale factor for the prior used in the Bayesian t.test.}

\item{descriptives}{Returns basic descriptive statistics for \code{cs1} and
\code{cs2}.}

\item{out.thres}{The threshold for detecting outliers (default is 3). If set
to 0, no outliers analysis will be performed. See \code{Details} below for
more information.}

\item{boxplot}{Should a boxplot of the variables be produced
(default is TRUE)?}
}
\value{
The function returns (at least) 3 list objects. These are: \code{descriptives},
\code{freq.results}, and \code{bayes.results}. In case outliers are detected,
then the outlier analyses are returned as well with the name \code{res.out}
as prefix to all list objects. For example, the descriptive statistics of
the outlier analyses, can be indexed by using
\code{obj$res.out$descriptives}, with obj being the object of the csCompare
results.

The values of the \code{descriptives} are described in
\code{psych::describe}.

The values of the \code{freq.results} are:
\code{method}: which test was run.

\code{alternative}: the alternative hypothesis.

\code{WG1, WG2}: the Shapiro test values, separately for group 1 and group 2.
In case of a paired-samples t-test, the WG2 is 0.

\code{WpG1, WpG2}: the p-values of Shapiro test, separately for group 1
and group 2. In case of a paired-samples t-test, the WpG2 is 0.

\code{null.value}: The value defined by \code{mu} (see above).

\code{LCI, HCI}: The low (\code{LCI}) and high (\code{HCI}) bounds
of the confidence intervals.

\code{t.statistic}: Logical.

\code{df}: The degrees of freedom of the t-test performed.

\code{p.value}: The p-value of the performed t-test.

\code{cohenD}: The Cohen's d for the performed t-test.

\code{cohenDM}: The magnitude of the resulting Cohen's d.

\code{hedgesG}: The Hedge's g for the performed t-test.

\code{hedgesGM}: The magnitude of the resulting Hedge's g.

The values of the \code{bayes.results} are:

\code{LNI, HNI}: The low (\code{LNI}) and high (\code{HNI}) intervals of the
hypothesis to test.

\code{rscale}: The used scale (see \code{rscale} argument above).

\code{bf10}: The BF10.

\code{bf01}: The BF01.

\code{propError}: The proportional error of the computed Bayes factor.
}
\description{
Compare CRs towards two CSs within a frequentist and
a Bayesian framework.
}
\details{
\code{csCompare} performs both a student t-test (using the
\code{stats::t.test} function) and a Bayesian t-test (using the
\code{BayesFactor::ttest.tstat}). If \code{cs1} and/or \code{cs2}
are or refer to multiple columns of a matrix or a data.frame, then
the row means are computed before the t-tests are performed.
In case \code{group} is \code{NULL},
paired-samples t-tests will be run. In case the \code{group} is different
than \code{NULL}, then the csCompare first computes difference scores between
 the cs1 and the cs2 (i.e., cs1 - cs2).
In case the group argument is defined
but, after removal of NA's (\code{stats::na.omit}), only one group
is present, a paired samples t-test is run.
In case of independent samples t-test, the function runs
a Welch's t-test.

Regarding outliers, those are detected based on the deviations from the
standardized residuals of each test. For example, in case of a paired-samples
t-test, the \code{csCompare} function will run an additional regression for
detecting deviations (defined in the \code{out.thres} argument)
from the standardized residuals. The detected outliers are removed from both
the frequentists and Bayesian analyses.
}
\examples{
set.seed(1000)
csCompare(cs1 = rnorm(n = 100, mean = 10), cs2 = rnorm(n = 100, mean = 9))
}
\references{
Krypotos, A. M., Klugkist, I., & Engelhard, I. M. (2017). 
Bayesian hypothesis testing for human threat conditioning research: 
An introduction and the condir R package. 
European Journal of Psychotraumatology, 8.

Rouder, J. N., Speckman, P. L., Sun, D., Morey, R. D., & Iverson, G. (2009).
Bayesian t-tests for accepting and rejecting the null hypothesis.
Psychonomic Bulletin & Review, 16, 225-237
}
\seealso{
\code{\link[stats]{t.test}}, \code{\link[BayesFactor]{ttest.tstat}}
}
