% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condor_submit.R
\name{condor_submit}
\alias{condor_submit}
\title{Condor Submit}
\usage{
condor_submit(local.dir = ".", run.dir = NULL, top.dir = "condor",
  exclude = "condor_mfcl|tar.gz|End", session = NULL)
}
\arguments{
\item{local.dir}{local directory containing a Condor \code{*.sub} file and
any other files necessary to run the job.}

\item{run.dir}{name of a Condor run directory to create inside
\code{top.dir}.}

\item{top.dir}{top directory on submitter machine that contains Condor run
directories.}

\item{exclude}{pattern identifying files in \code{local.dir} that should not
be submitted to Condor.}

\item{session}{optional object of class \code{ssh_connect}.}
}
\value{
Remote directory name with the job id as a name attribute.
}
\description{
Submit a Condor job.
}
\details{
The default value of \code{run.dir = NULL} runs the Condor job in
\emph{top.dir}\code{/}\emph{local.dir}. For example, if
\code{local.dir = "c:/yft/run01"} then the default \code{run.dir} becomes
\code{"condor/run01"}.

It can be practical to organize Condor runs inside the default
\code{top.dir = "condor"} directory, to keep Condor runs separate from other
directories inside the user home. To organize Condor runs directly in the
home folder on the submitter machine, pass \code{top.dir = ""}.

The default value of \code{session = NULL} looks for a \code{session} object
in the user workspace. This allows the user to run Condor functions without
explicitly specifying the \code{session}.
}
\note{
This function performs two core tasks: (1) upload files from \code{local.dir}
to submitter machine, and (2) execute shell command \command{condor_submit}
on submitter machine to launch the Condor job.
}
\examples{
\dontrun{
session <- ssh_connect("servername")

condor_submit()
condor_q()
condor_dir()
condor_download()  # after job has finished
}

}
\seealso{
\code{condor_submit}, \code{\link{condor_q}}, \code{\link{condor_dir}}, and
\code{\link{condor_download}} provide the main Condor interface.

\code{\link{condor-package}} gives an overview of the package.
}
