% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cont2color.R
\name{cont2color}
\alias{cont2color}
\title{Assign colours to numeric vector}
\usage{
cont2color(x, xrange = NULL, breaks = NULL, colors = NULL)
}
\arguments{
\item{x}{A numeric vector.}

\item{xrange}{The range to use for the colour scale.}

\item{breaks}{The number of breaks at which to change colour.}

\item{colors}{The colours to use. Defaults to a diverging colour scheme;
either \code{"PiYG"} from \code{RColorBrewer} if available, or
\code{\link{cm.colors}} otherwise.}
}
\value{
A character vector of colours.
}
\description{
This function assigns colours on a linear scale to a numeric
  vector. Default is to try to use \code{RColorBrewer} for colours, and
  \code{\link{cm.colors}} otherwise. Can provide custom range, breaks and colours.
}
\details{
Uses the \code{RColorBrewer} package if installed. Coerces \code{x}
  to numeric with a warning.
}
\examples{
x <- runif(200)
plot(x, col = cont2color(x, c(0,1)))

plot(x, col = cont2color(x, c(0,0.5)))

plot(sort(x), col = cont2color(sort(x), c(0.25,0.75)), pch = 16)
abline(h = c(0.25, 0.75), lty = 3)

}
\seealso{
\code{\link{factor2color}}
}

