% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read.config}
\alias{read.config}
\title{Read from the file (JSON/INI/YAML/TOML be supported), retreiving all values as a list.}
\usage{
read.config(file = Sys.getenv("R_CONFIGFILE_ACTIVE", "config.cfg"), ...)
}
\arguments{
\item{file}{File name of configuration file to read from. Defaults to the value of
the ‘R_CONFIGFILE_ACTIVE’ environment variable ('config.cfg' if the
variable does not exist and JSON/INI/YAML/TOML format only)}

\item{...}{Arguments for \code{\link{get.config.type}}, 
\code{\link[jsonlite]{fromJSON}}, \code{\link[ini]{read.ini}},
\code{\link[yaml]{yaml.load_file}}, \code{\link[RcppTOML]{parseTOML}}, 
\code{\link{readLines}}}
}
\value{
All values as a list or 
logical FALSE indicating that is not standard JSON/INI/YAML/TOML format file
}
\description{
Read from the file (JSON/INI/YAML/TOML be supported), retreiving all values as a list.
}
\examples{
config.json <- system.file('extdata', 'config.json', package='configr')
config <- read.config(file=config.json)
}
\seealso{
\code{\link[jsonlite]{fromJSON}} JSON file will read by this

\code{\link[ini]{read.ini}} INI file will read by this

\code{\link[yaml]{yaml.load_file}} YAML file will read by this

\code{\link[RcppTOML]{parseTOML}} TOML file will read by this
}

