% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infoHelpers.R
\name{informationWrightMap}
\alias{informationWrightMap}
\title{informationWrightMap}
\usage{
informationWrightMap(
  myItems,
  myAbilities,
  type = "empirical",
  minTheta = NA,
  maxTheta = NA,
  stepTheta = NA,
  scaleInfo = 1
)
}
\arguments{
\item{myItems}{A vector of item deltas.}

\item{myAbilities}{A vector of person abilities.}

\item{type}{A character String.
Should the test information be calculated empirically ("empirical" - default) or analytically using moments of distribution ("approx").}

\item{minTheta}{The smallest value of ability PDF to plot.}

\item{maxTheta}{The largest value of ability PDF to plot.}

\item{stepTheta}{The increment to iterate over the ability PDF. Defaults to 0.01.}

\item{scaleInfo}{A scaling factor to apply to the plot of tesr information.
Because ability distribution is a PDF with area one, and a test information function has area L, this can make the plot more interpretable. Defaults to 1.}
}
\value{
A ggplot2 object.
}
\description{
Plots test information function, relative to ability density, and item locations.
}
\examples{
myInfoPlot<- informationWrightMap(runif(10, -2, 3), rnorm(1000, 0, 1), minTheta=-10, maxTheta=10)
}
