% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contactDur.all.R
\name{contactDur.all}
\alias{contactDur.all}
\title{Identify Inter-animal Contacts}
\usage{
contactDur.all(
  x,
  dist.threshold = 1,
  sec.threshold = 10,
  blocking = FALSE,
  blockLength = 1,
  blockUnit = "hours",
  blockingStartTime = NULL,
  equidistant.time = FALSE,
  parallel = FALSE,
  nCores = (parallel::detectCores()/2),
  reportParameters = TRUE
)
}
\arguments{
\item{x}{Output from the dist2All function. Can be either a data frame or 
non-data-frame list.}

\item{dist.threshold}{Numeric. Radial distance (in meters) within which 
"contact" can be said to occur. Defaults to 1. Note: If you are 
defining conttacts as occurring when polygons intersect, set 
dist.threshold to 0.}

\item{sec.threshold}{Numeric. Dictates the maximum amount of time between 
concurrent observations during which potential "contact" events remain 
unbroken. Defaults to 10.}

\item{blocking}{Logical. If TRUE, contacts will be evaluated for temporal 
blocks spanning blockLength blockUnit (e.g., 6 hours) within the data 
set. Defaults to FALSE.}

\item{blockLength}{Integer. Describes the number blockUnits within each 
temporal block. Defaults to 1.}

\item{blockUnit}{Character string taking the values, "secs," "mins," 
"hours," "days," or "weeks." Describes the temporal unit associated with
each block. Defaults to "hours."}

\item{blockingStartTime}{Character string or date object describing the date
OR dateTime starting point of the first time block. For example, if 
blockingStartTime = "2016-05-01" OR "2016-05-01 00:00:00", the first 
timeblock would begin at "2016-05-01 00:00:00." If NULL, the 
blockingStartTime defaults to the minimum dateTime point in x. Note: 
any blockingStartTime MUST precede or be equivalent to the minimum 
timepoint in x. Additional note: If blockingStartTime is a character 
string, it must be in the format ymd OR ymd hms.}

\item{equidistant.time}{Logical. If TRUE, location fixes in individuals' 
movement paths are temporally equidistant (e.g., all fix intervals are 
30 seconds). Defaults to FALSE. Note: This is a time-saving argument. 
A sub-function here calculates the time difference (dt) between each 
location fix. If all fix intervals in an individuals' path are 
identical, it saves a lot of time.}

\item{parallel}{Logical. If TRUE, sub-functions within the contactDur.all 
wrapper will be parallelized. Defaults to FALSE.}

\item{nCores}{Integer. Describes the number of cores to be dedicated to 
parallel processes. Defaults to half of the maximum number of cores 
available (i.e., (parallel::detectCores()/2)).}

\item{reportParameters}{Logical. If TRUE, function argument values will be 
appended to output data frame(s). Defaults to TRUE.}
}
\value{
Returns a data frame (or list of data frames if \code{x} is a 
   list of data frames) with the following columns:
   
   \item{dyadMember1}{The unique ID of an individual observed in contact 
   with a specified second individual.}
   \item{dyadMember2}{The unique ID of an individual observed in contact 
   with \code{dyadMember1}.}
   \item{dyadID}{The unique dyad ID used to identify the pair
   of individuals \code{dyadMember1} and \code{dyadMember2}.}    
   \item{contactDuration}{The number of sequential timepoints in \code{x} 
   that \code{dyadMember1} and \code{dyadMember2} were observed to be in 
   contact with one another.}
   \item{contactStartTime}{The timepoint in \code{x} at which contact
   between \code{dyadMember1} and \code{dyadMember2} begins.}
   \item{contactEndTime}{The timepoint in \code{x} at which contact
   between \code{dyadMember1} and \code{dyadMember2} ends.}
   
   If blocking == TRUE, the following columns are appended to the output
   data frame described above:
   
   \item{block}{Integer ID describing unique blocks of time during which 
   contacts occur.}
   \item{block.start}{The timepoint in \code{x} at which the \code{block}
   begins.}
   \item{block.end}{The timepoint in \code{x} at which the \code{block}
   ends.}
   \item{numBlocks}{Integer describing the total number of time blocks 
   observed within \code{x} at which the \code{block}}
    
   Finally, if reportParameters == TRUE function arguments 
   \code{distThreshold}, \code{secThreshold}, \code{equidistant.time},
   and \code{blockLength} (if applicable) will be appended to the 
   output data frame.
}
\description{
This function uses the output from dist2All to determine when and for how 
    long tracked individuals are in "contact" with one another. Individuals 
    are said to be in a "contact" event if they are observed within a given 
    distance (<= dist.threshold) at a given timestep. Contacts are broken 
    when individuals are observed outside the specified distance threshold 
    from one another for > sec.threshold seconds. Sec.threshold dictates the
    maximum amount of time between concurrent observations during which 
    potential "contact" events remain unbroken. For example, if 
    sec.threshold == 10, only "contacts" occurring within 10secs of one 
    another will be regarded as a single "contact" event of duration sum(h).
    If in this case, a time difference between contacts was 11 seconds, the 
    function will report two separate contact events.
    
The output of this function is a data frame containing a time-ordered 
    contact edge set detailing inter-animal contacts.
}
\examples{

data(calves)

calves.dateTime<-datetime.append(calves, date = calves$date, time =
    calves$time) #create a dataframe with dateTime identifiers for location foxes
    
calves.agg<-tempAggregate(calves.dateTime, id = calves.dateTime$calftag,
    dateTime = calves.dateTime$dateTime, point.x = calves.dateTime$x,
    point.y = calves.dateTime$y, secondAgg = 300, extrapolate.left = FALSE,
    extrapolate.right = FALSE, resolutionLevel = "reduced", parallel = FALSE,
    na.rm = TRUE, smooth.type = 1) #smooth locations to 5-min fix intervals.

calves.dist<-dist2All_df(x = calves.agg, parallel = FALSE, dataType = "Point",
    lonlat = FALSE) #calculate distance between all individuals at each timepoint
    
calves.contact.block<-contactDur.all(x = calves.dist, dist.threshold=1,
    sec.threshold=10, blocking = TRUE, blockUnit = "hours", blockLength = 1,
    equidistant.time = FALSE, parallel = FALSE, reportParameters = TRUE)
    
calves.contact.NOblock<-contactDur.all(x = calves.dist, dist.threshold=1,
    sec.threshold=10, blocking = FALSE, blockUnit = "hours", blockLength = 1,
    equidistant.time = FALSE, parallel = FALSE, reportParameters = TRUE)
}
\keyword{contact}
\keyword{data-processing}
