% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdf2txtAI.R
\name{gemini_content_ai}
\alias{gemini_content_ai}
\title{Process Content with Google Gemini AI}
\usage{
gemini_content_ai(
  image = NULL,
  docs = NULL,
  prompt = "Explain these images",
  model = "2.0-flash",
  image_type = "png",
  retry_503 = 5,
  api_key = NULL,
  outputSize = "medium"
)
}
\arguments{
\item{image}{Character vector. Path(s) to image file(s) to be processed. Default is NULL.}

\item{docs}{Character vector. Path(s) to document file(s) to be processed. Default is NULL.}

\item{prompt}{Character. The prompt/instruction for the AI model.
Default is "Explain these images".}

\item{model}{Character. The Gemini model version to use. Default is "2.0-flash".
Options include "1.5-flash", "2.0-flash", "2.5-flash", etc.}

\item{image_type}{Character. The image MIME type. Default is "png".}

\item{retry_503}{Integer. Number of retry attempts for HTTP 503 errors. Default is 5.}

\item{api_key}{Character. Google Gemini API key. If NULL, uses the
GEMINI_API_KEY environment variable.}

\item{outputSize}{Character. Controls the maximum output tokens. Options are:
\itemize{
\item "small": 8,192 tokens
\item "medium": 16,384 tokens (default)
\item "large": 32,768 tokens
\item "huge": 131,072 tokens
}}
}
\value{
Character vector containing the AI-generated response(s), or an error message
string starting with "ERROR:" if the request fails.
}
\description{
Send images and/or documents to Google Gemini AI for content analysis and generation.
The function supports multiple file types including images (PNG, JPG, etc.) and documents
(PDF, TXT, HTML, CSV, RTF).
}
\details{
The function handles various error scenarios including:
\itemize{
\item Missing or invalid files
\item Invalid API keys (HTTP 400)
\item Service unavailability (HTTP 503/429) with automatic retry
\item File encoding errors
}

Supported document types: PDF, TXT, HTML, CSV, RTF
}
\examples{
\dontrun{
# Process an image
result <- gemini_content_ai(
  image = "path/to/image.png",
  prompt = "Describe this image in detail"
)

# Process a PDF document
result <- gemini_content_ai(
  docs = "path/to/document.pdf",
  prompt = "Summarize this document",
  outputSize = "large"
)

# Process multiple images and documents
result <- gemini_content_ai(
  image = c("img1.png", "img2.png"),
  docs = c("doc1.pdf", "doc2.txt"),
  prompt = "Compare these materials"
)
}

}
