% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/the_2x2_table_CIs_ratio.R
\name{the_2x2_table_CIs_ratio}
\alias{the_2x2_table_CIs_ratio}
\title{The 2x2 table CIs ratio}
\usage{
the_2x2_table_CIs_ratio(n, alpha = 0.05)
}
\arguments{
\item{n}{frequency matrix}

\item{alpha}{type I error}
}
\value{
A string of "-". This function should be called for its printed output
}
\description{
Wrapper for \code{_CI_2x2} functions on Chapter 4.
}
\examples{
# An RCT of high vs standard dose of epinephrine (Perondi et al., 2004)
n <- matrix(c(7, 27, 1, 33), nrow=2, byrow=TRUE)
the_2x2_table_CIs_ratio(n)

# The association between CHRNA4 genotype and XFS (Ritland et al., 2007)
n <- matrix(c(0, 16, 15, 57), nrow=2, byrow=TRUE)
the_2x2_table_CIs_ratio(n)

}
\seealso{
the_2x2_table_CIs_difference the_2x2_table_CIs_OR the_2x2_table_tests
}
