% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scheffe_type_CIs_paired_cxc.R
\name{Scheffe_type_CIs_paired_cxc}
\alias{Scheffe_type_CIs_paired_cxc}
\title{ScheffE-type confidence intervals for differences of marginal probabilities}
\usage{
Scheffe_type_CIs_paired_cxc(n, alpha = 0.05, printresults = TRUE)
}
\arguments{
\item{n}{the observed table (a cxc matrix)}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A list containing lower, upper and point estimates of the statistic
}
\description{
ScheffE-type confidence intervals for differences of marginal probabilities

Described in Chapter 9 "The Paired kxk Table"
}
\examples{
# Pretherapy susceptability of pathogens (Peterson et al., 2007)
n <- rbind(c(596, 18, 6, 5), c(0, 2, 0, 0), c(0, 0, 42, 0), c(11, 0, 0, 0))
Scheffe_type_CIs_paired_cxc(n)
}
