set.seed(3755232)

context("Output class, name and length")

# Common elements ======================================== #

n  <- matrix(c(9, 4, 4, 10), nrow = 2, byrow = TRUE)
n2 <- rbind(c(596, 18, 6, 5), c(0, 2, 0, 0), c(0, 0, 42, 0), c(11, 0, 0, 0))
n3 <- rbind(c(14, 10, 3, 2), c(11, 7, 8, 4))
n4 <- array(c(c(647, 2, 622, 27), c(41, 19, 28, 32)), dim = c(2, 2, 2))
n5 <- matrix(1:9, 3)
n6 <- matrix(1:8, ncol = 2)
n7 <- floor(matrix(c(14, 10, 3, 2, 11, 7, 8, 4), nrow = 2, byrow = TRUE) / 4)

# Unit tests ============================================= #

test_that("Output classes are the expected", {
  # TODO: if there's no particular reason for the output classes to be different, they
  # should be standardized.
  expect_is(Adjusted_inv_sinh_CI_OR_2x2(n, printresults = FALSE), "data.frame")
  expect_is(Adjusted_inv_sinh_CI_ratio_2x2(n, printresults = FALSE), "data.frame")
  expect_is(Adjusted_log_CI_2x2(n, printresults = FALSE), "data.frame")
  expect_is(AgrestiCaffo_CI_2x2(n, printresults = FALSE), "data.frame")
  expect_is(AgrestiCoull_CI_1x2(33, 45, printresults = FALSE), "numeric")
  expect_is(BaptistaPike_exact_conditional_CI_2x2(n, printresults = FALSE), "data.frame")
  expect_is(BaptistaPike_midP_CI_2x2(n, printresults = FALSE), "data.frame")
  expect_is(Bhapkar_test_paired_cxc(n2, printresults = FALSE), "list")
  expect_is(Blaker_exact_CI_1x2(13, 16, printresults = FALSE), "numeric")
  expect_is(Blaker_exact_test_1x2(13, 16, .5, printresults = FALSE), "numeric")
  expect_is(Blaker_midP_CI_1x2(13, 16, printresults = FALSE), "numeric")
  expect_is(Blaker_midP_test_1x2(13, 16, .5, printresults = FALSE), "numeric")
  expect_is(BonettPrice_hybrid_Wilson_score_CI_CC_paired_2x2(n, printresults = FALSE), "list")
  expect_is(BonettPrice_hybrid_Wilson_score_CI_paired_2x2(n, printresults = FALSE), "list")
  expect_is(Bonferroni_type_CIs_paired_cxc(n, printresults = FALSE), "list")
  expect_is(Bonferroni_type_CIs_rxc(n, printresults = FALSE), "list")
  expect_is(Brant_test_2xc(n3, printresults = FALSE), "data.frame")
  expect_is(BreslowDay_homogeneity_test_stratified_2x2(n4, printresults = FALSE), "list")
  expect_is(Chacko_test_1xc(n, printresults = FALSE), "data.frame")
  expect_is(ClopperPearson_exact_CI_1x2_beta_version(13, 16, printresults = FALSE), "list")
  expect_is(ClopperPearson_exact_CI_1x2(13, 16, printresults = FALSE), "numeric")
  expect_is(ClopperPearson_midP_CI_1x2(13, 16, printresults = FALSE), "numeric")
  expect_is(Cochran_Q_test_stratified_2x2(n4, printresults = FALSE), "list")
  expect_is(CochranArmitage_CI_rx2(n, 1:2, printresults = FALSE), "data.frame")
  expect_is(CochranArmitage_exact_cond_midP_tests_rx2(n2, 1:4, printresults = FALSE), "data.frame")
  expect_is(CochranArmitage_MH_tests_rx2(n2, 1:4, printresults = FALSE), "list")
  expect_is(CochranMantelHaenszel_test_stratified_2x2(n4, printresults = FALSE), "list")
  expect_is(Cornfield_exact_conditional_CI_2x2(n, printresults = FALSE), "data.frame")
  expect_is(Cornfield_midP_CI_2x2(n, printresults = FALSE), "data.frame")
  expect_is(Cumulative_models_for_2xc(n3, printresults = FALSE), "list")
  expect_is(Cumulative_models_for_rxc(n3, printresults = FALSE), "list")
  expect_is(Exact_binomial_test_1x2(13, 16, .5, printresults = FALSE), "numeric")
  expect_is(Exact_cond_midP_linear_rank_tests_2xc(n5, printresults = FALSE), "data.frame")
  expect_is(Exact_cond_midP_tests_rxc(n5[, 1:2], printresults = FALSE), "list")
  expect_is(Exact_cond_midP_unspecific_ordering_rx2(n6, "decreasing", printresults = FALSE), "data.frame")
  expect_is(Exact_multinomial_test_1xc(1:3, seq(.4, .6, .1), printresults = FALSE), "numeric")
  expect_is(Exact_unconditional_test_2x2(n, printresults = FALSE), "numeric")
  expect_is(Fisher_exact_test_2x2(n, printresults = FALSE), "numeric")
  expect_is(Exact_unconditional_test_2x2(n, printresults = FALSE), "numeric")
  expect_is(Fisher_midP_test_2x2(n, printresults = FALSE), "numeric")
  expect_is(FisherFreemanHalton_asymptotic_test_rxc(n, printresults = FALSE), "list")
  expect_is(FleissEveritt_test_paired_cxc(n5, printresults = FALSE), "list")
  expect_is(FleissLevinPaik_test_paired_cxc(n5, printresults = FALSE), "list")
  expect_is(gamma_coefficient_rxc_bca(n, nboot = 300, printresults = FALSE), "list")
  expect_is(gamma_coefficient_rxc(n, printresults = FALSE), "list")
  expect_is(Gart_adjusted_logit_CI_2x2(n, printresults = FALSE), "data.frame")
  expect_is(Gold_Wald_CIs_1xc(n, printresults = FALSE), "data.frame")
  expect_is(Goodman_Wald_CIs_1xc(n, printresults = FALSE), "data.frame")
  expect_is(Goodman_Wald_CIs_for_diffs_1xc(n, printresults = FALSE), "data.frame")
  expect_is(Goodman_Wilson_score_CIs_1xc(n, printresults = FALSE), "data.frame")
  expect_is(Independence_smoothed_logit_CI_2x2(n, printresults = FALSE), "data.frame")
  expect_is(Inv_sinh_CI_OR_2x2(n, printresults = FALSE), "data.frame")
  expect_is(Inv_sinh_CI_ratio_2x2(n, printresults = FALSE), "data.frame")
  expect_is(InverseVariance_estimate_stratified_2x2(n4, printresults = FALSE), "list")
  expect_is(Jeffreys_CI_1x2(13, 16, printresults = FALSE), "numeric")
  expect_is(JonckheereTerpstra_test_rxc(n, printresults = FALSE), "list")
  expect_is(Katz_log_CI_2x2(n, printresults = FALSE), "data.frame")
  expect_is(Kendalls_tau_b_rxc_bca(n, nboot = 200, printresults = FALSE), "list")
  expect_is(Kendalls_tau_b_rxc(n, printresults = FALSE), "list")
  expect_is(Koopman_asymptotic_score_CI_2x2(n, printresults = FALSE), "data.frame")
  expect_is(KruskalWallis_asymptotic_test_rxc(n, printresults = FALSE), "list")
  expect_is(linear_by_linear_test_rxc(n, printresults = FALSE), "list")
  expect_is(LR_CI_1x2(13, 16, printresults = FALSE), "numeric")
  expect_is(LR_test_1x2(13, 16, .3, printresults = FALSE), "numeric")
  expect_is(LR_test_1xc(1:3, c(.3, .5, .1), printresults = FALSE), "data.frame")
  expect_is(LR_test_2x2(n, printresults = FALSE), "data.frame")
  expect_is(MantelHaenszel_estimate_stratified_2x2(n4, printresults = FALSE), "list")
  expect_is(MantelHaenszel_test_2xc(n, printresults = FALSE), "data.frame")
  expect_is(McNemar_asymptotic_test_CC_paired_2x2(n, printresults = FALSE), "list")
  expect_is(McNemar_asymptotic_test_paired_2x2(n, printresults = FALSE), "list")
  expect_is(McNemar_exact_cond_test_paired_2x2(n2, printresults = FALSE), "numeric")
  expect_is(McNemar_exact_unconditional_test_paired_2x2(n, printresults = FALSE), "numeric")
  expect_is(McNemar_midP_test_paired_2x2(n, printresults = FALSE), "numeric")
  expect_is(McNemarBowker_test_paired_cxc(n, printresults = FALSE), "list")
  expect_is(Mee_asymptotic_score_CI_2x2(n, printresults = FALSE), "data.frame")
  expect_is(MidP_binomial_test_1x2(13, 16, .3, printresults = FALSE), "numeric")
  expect_is( MidP_multinomial_test_1xc(n, runif(4), printresults = FALSE), "numeric")
  expect_is(MiettinenNurminen_asymptotic_score_CI_difference_2x2(n, printresults = FALSE), "data.frame")
  expect_is(MiettinenNurminen_asymptotic_score_CI_OR_2x2(n, printresults = FALSE), "data.frame")
  expect_is(MiettinenNurminen_asymptotic_score_CI_ratio_2x2(n, printresults = FALSE), "data.frame")
  expect_is(ML_estimates_and_CIs_stratified_2x2(n4, printresults = FALSE), "list")
  expect_is(MOVER_R_Wilson_CI_OR_2x2(n, printresults = FALSE), "data.frame")
  expect_is(MOVER_R_Wilson_CI_ratio_2x2(n, printresults = FALSE), "data.frame")
  expect_is(MOVER_Wilson_score_CI_paired_2x2(n, printresults = FALSE), "list")
  expect_is(Newcombe_hybrid_score_CI_2x2(n, printresults = FALSE), "data.frame")
  expect_is(Newcombe_square_and_add_CI_paired_2x2(n, printresults = FALSE), "list")
  expect_is(Pearson_chi_squared_test_1xc(n, runif(4), printresults = FALSE), "data.frame")
  expect_is(Pearson_chi_squared_test_2x2(n, printresults = FALSE), "data.frame")
  expect_is(Pearson_chi_squared_test_CC_2x2(n, printresults = FALSE), "data.frame")
  expect_is(Pearson_correlation_coefficient_rxc_bca(n, nboot = 200, printresults = FALSE), "list")
  expect_is(Pearson_correlation_coefficient_rxc(n, printresults = FALSE), "list")
  expect_is(Pearson_LR_homogeneity_test_stratified_2x2(n4, printresults = FALSE), "list")
  expect_is(Pearson_LR_test_common_effect_stratified_2x2(n4, printresults = FALSE), "list")
  expect_is(Pearson_LR_tests_cum_OR_2xc(n, printresults = FALSE), "list")
  expect_is(Pearson_LR_tests_rxc(n, printresults = FALSE), "list")
  expect_is(Pearson_LR_tests_unspecific_ordering_rx2(n, "increasing", printresults = FALSE), "list")
  expect_is(Pearson_residuals_rxc(n, printresults = FALSE), "list")
  expect_is(Peto_homogeneity_test_stratified_2x2(n4, printresults = FALSE), "list")
  expect_is(Peto_OR_estimate_stratified_2x2(n4, printresults = FALSE), "list")
  expect_is(PriceBonett_approximate_Bayes_CI_2x2(n, printresults = FALSE), "data.frame")
  expect_is(QuesenberryHurst_Wilson_score_CIs_1xc(n, printresults = FALSE), "data.frame")
  expect_is(RBG_test_and_CI_stratified_2x2(n4, printresults = FALSE), "list")
  expect_is(Scheffe_type_CIs_paired_cxc(n, printresults = FALSE), "list")
  expect_is(Scheffe_type_CIs_rxc(n, printresults = FALSE), "list")
  expect_is(Score_test_1x2(13, 16, .5, printresults = FALSE), "numeric")
  expect_is(Score_test_and_CI_marginal_mean_scores_paired_cxc(n, runif(4), printresults = FALSE), "list")
  expect_is(Score_test_CC_1x2(13, 16, .5, printresults = FALSE), "numeric")
  expect_is(Score_test_for_effect_in_the_probit_model_2xc(n, rnorm(4), printresults = FALSE), "data.frame")
  expect_is(Spearman_correlation_coefficient_rxc_bca(n, nboot = 200, printresults = FALSE), "list")
  expect_is(Spearman_correlation_coefficient_rxc(n, printresults = FALSE), "list")
  expect_is(invisible(capture.output(stratified_2x2_tables(n4))), "character")
  expect_is(Stuart_test_paired_cxc(n2, printresults = FALSE), "list")
  expect_is(Tang_asymptotic_score_CI_paired_2x2(n, printresults = FALSE), "list")
  expect_is(Tango_asymptotic_score_CI_paired_2x2(n, printresults = FALSE), "list")
  expect_is(invisible(capture.output(the_1x2_table_CIs(13, 16))), "character")
  expect_is(invisible(capture.output(the_1x2_table_tests(13, 16, .4))), "character")
  expect_is(invisible(capture.output(the_1xc_table_CIs(n))), "character")
  expect_is(invisible(capture.output(the_1xc_table_tests(n, runif(4)))), "character")
  expect_is(invisible(capture.output(the_2x2_table_CIs_difference(n))), "character")
  expect_is(invisible(capture.output(the_2x2_table_CIs_OR(n))), "character")
  expect_is(invisible(capture.output(the_2x2_table_CIs_ratio(n))), "character")
  expect_is(invisible(capture.output(the_2x2_table_tests(n))), "character")
  expect_is(invisible(capture.output(the_2xc_table(n7, direction = "decreasing"))), "character")
  expect_is(invisible(capture.output(the_paired_2x2_table_CIs_difference(n))), "character")
  expect_is(invisible(capture.output(the_paired_2x2_table_CIs_OR(n))), "character")
  expect_is(invisible(capture.output(the_paired_2x2_table_CIs_ratio(n))), "character")
  expect_is(invisible(capture.output(the_paired_2x2_table_tests(n))), "character")
  expect_is(invisible(capture.output(the_paired_cxc_table_nominal(n))), "character")
  expect_is(invisible(capture.output(the_paired_cxc_table_ordinal(n, rnorm(4)))), "character")
  expect_is(invisible(capture.output(the_rx2_table(n2, skip_exact = TRUE))), "character")
  expect_is(invisible(capture.output(the_rxc_table(n2, nboot = 0))), "character")
  expect_is(Transformed_Blaker_exact_CI_paired_2x2(n, printresults = FALSE), "list")
  expect_is(Transformed_Clopper_Pearson_exact_CI_paired_2x2(n, printresults = FALSE), "list")
  expect_is(Transformed_Clopper_Pearson_midP_CI_paired_2x2(n, printresults = FALSE), "list")
  expect_is(Transformed_Wilson_score_CI_paired_2x2(n, printresults = FALSE), "list")
  expect_is(Trend_estimate_CI_tests_rx2(n, 1:2, printresults = FALSE), "list")
  expect_is(Uncorrected_asymptotic_score_CI_2x2(n, printresults = FALSE), "data.frame")
  expect_is(Wald_CI_1x2(13, 16, printresults = FALSE), "numeric")
  expect_is(Wald_CI_2x2(n, printresults = FALSE), "data.frame")
  expect_is(Wald_CI_AgrestiMin_paired_2x2(n, printresults = FALSE), "list")
  expect_is(Wald_CI_BonettPrice_paired_2x2(n, printresults = FALSE), "list")
  expect_is(Wald_CI_CC_1x2(13, 16, printresults = FALSE), "numeric")
  expect_is(Wald_CI_CC_2x2(n, printresults = FALSE), "data.frame")
  expect_is(Wald_CI_diff_CC_paired_2x2(n, printresults = FALSE), "list")
  expect_is(Wald_CI_diff_paired_2x2(n, printresults = FALSE), "list")
  expect_is(Wald_CI_OR_Laplace_paired_2x2(n, printresults = FALSE), "list")
  expect_is(Wald_CI_OR_paired_2x2(n, printresults = FALSE), "list")
  expect_is(Wald_CI_ratio_paired_2x2(n, printresults = FALSE), "list")
  expect_is(Wald_test_1x2(13, 16, .1, printresults = FALSE), "numeric")
  expect_is(Wald_test_and_CI_common_diff_stratified_2x2(n4, printresults = FALSE), "list")
  expect_is(Wald_test_and_CI_common_ratio_stratified_2x2(n4, printresults = FALSE), "list")
  expect_is(Wald_test_and_CI_marginal_mean_ranks_paired_cxc(n, printresults = FALSE), "list")
  expect_is(Wald_test_and_CI_marginal_mean_scores_paired_cxc(n, rnorm(4), printresults = FALSE), "list")
  expect_is(Wald_test_CC_1x2(13, 16, .1, printresults = FALSE), "numeric")
  expect_is(Wilson_score_CI_1x2(13, 16, printresults = FALSE), "numeric")
  expect_is(Wilson_score_CI_CC_1x2(13, 16, printresults = FALSE), "numeric")
  expect_is(Woolf_logit_CI_2x2(n, printresults = FALSE), "data.frame")
  expect_is(Woolf_test_and_CI_stratified_2x2(n4, printresults = FALSE), "list")
  expect_is(Z_unpooled_test_2x2(n, printresults = FALSE), "data.frame")
})

test_that("Output names are the expected", {
  lue <- c("lower", "upper", "estimate")
  ptdf <- c("P", "T", "df")
  LUe <- c("L", "U", "estimate")
  LUdelta <- c("L", "U", "deltahat")
  LUdiff <- c("L", "U", "differences")
  luee <- c("lower", "upper", "estimate.1", "estimate.2")
  pz <- c("P", "Z")
  psdf <- c("p.value", "statistic", "df")
  rplu <- c("rP", "L", "U")
  plr_df <- c("P_LR", "T_LR", "df_LR", "P_Pearson", "T_Pearson", "df_Pearson")
  plr <- c("T_Pearson", "P_Pearson", "T_LR", "P_LR")
  ps <- c("p.value", "statistic")
  expect_named(Adjusted_inv_sinh_CI_OR_2x2(n, printresults = FALSE), lue)
  expect_named(Adjusted_inv_sinh_CI_ratio_2x2(n, printresults = FALSE), lue)
  expect_named(Adjusted_log_CI_2x2(n, printresults = FALSE), lue)
  expect_named(AgrestiCaffo_CI_2x2(n, printresults = FALSE), lue)
  expect_named(AgrestiCoull_CI_1x2(33, 45, printresults = FALSE), lue)
  expect_named(Arcsine_CI_1x2(13, 16, printresults = FALSE), lue)
  expect_named(BaptistaPike_exact_conditional_CI_2x2(n, printresults = FALSE), lue)
  expect_named(BaptistaPike_midP_CI_2x2(n, printresults = FALSE), lue)
  expect_named(Bhapkar_test_paired_cxc(n2, printresults = FALSE), ptdf)
  expect_named(Blaker_exact_CI_1x2(13, 16, printresults = FALSE), lue)
  expect_named(Blaker_exact_test_1x2(13, 16, .5, printresults = FALSE), NULL)
  expect_named(Blaker_midP_CI_1x2(13, 16, printresults = FALSE), lue)
  expect_named(Blaker_midP_test_1x2(13, 16, .5, printresults = FALSE), NULL)
  expect_named(BonettPrice_hybrid_Wilson_score_CI_CC_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(BonettPrice_hybrid_Wilson_score_CI_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(Bonferroni_type_CIs_paired_cxc(n, printresults = FALSE), LUdelta)
  expect_named(Bonferroni_type_CIs_rxc(n, printresults = FALSE), LUdiff)
  expect_named(Brant_test_2xc(n3, printresults = FALSE), ptdf)
  expect_named(BreslowDay_homogeneity_test_stratified_2x2(n4, printresults = FALSE), ptdf)
  expect_named(Chacko_test_1xc(n, printresults = FALSE), ptdf)
  expect_named(ClopperPearson_exact_CI_1x2_beta_version(13, 16, printresults = FALSE), LUe)
  expect_named(ClopperPearson_exact_CI_1x2(13, 16, printresults = FALSE), lue)
  expect_named(ClopperPearson_midP_CI_1x2(13, 16, printresults = FALSE), lue)
  expect_named(Cochran_Q_test_stratified_2x2(n4, printresults = FALSE), c("P", "Q", "df"))
  expect_named(CochranArmitage_CI_rx2(n, 1:2, printresults = FALSE), lue)
  expect_named(CochranArmitage_exact_cond_midP_tests_rx2(n2, 1:4, printresults = FALSE), c("P", "midP"))
  expect_named(CochranArmitage_MH_tests_rx2(n2, 1:4, printresults = FALSE), c("Z_CA", "P_CA", "Z_CA_mod", "P_CA_mod", "Z_MH", "P_MH"))
  expect_named(CochranMantelHaenszel_test_stratified_2x2(n4, printresults = FALSE), ptdf)
  expect_named(Cornfield_exact_conditional_CI_2x2(n, printresults = FALSE), lue)
  expect_named(Cornfield_midP_CI_2x2(n, printresults = FALSE), lue)
  expect_named(
    Cumulative_models_for_2xc(n3, printresults = FALSE),
    c(
      "betahat", "OR", "se", "D", "P_D", "df_D", "X2", "P_X2", "df_X2",
      "Z_Wald", "T_Wald", "P_Wald", "T_LR", "P_LR", "df_LR", "Z_MW", "P_MW",
      "Wald_CI", "Wald_CI_OR", "Wald_CI_width"
    )
  )
  expect_named(
    Cumulative_models_for_rxc(n3, printresults = FALSE),
    c(
      "betahat", "OR", "se", "D", "df_D", "P_D", "X2", "df_X2", "P_X2",
      "Z_Wald", "T_Wald", "P_Wald", "T_LR", "df_LR", "P_LR", "Wald_CI",
      "Wald_CI_OR", "Wald_CI_width"
    )
  )
  expect_named(Exact_binomial_test_1x2(13, 16, .5, printresults = FALSE), NULL)
  expect_named(Exact_cond_midP_linear_rank_tests_2xc(n5, printresults = FALSE), c("P", "midP"))
  expect_named(Exact_cond_midP_tests_rxc(n5[, 1:2], printresults = FALSE), c("P_FFH", "midP_FFH", "P_Pearson", "midP_Pearson", "P_LR", "midP_LR", "P_KW", "midP_KW", "P_lbl", "midP_lbl", "P_JT", "midP_JT"))
  expect_named(Exact_cond_midP_unspecific_ordering_rx2(n6, "decreasing", printresults = FALSE), c("P", "midP"))
  expect_named(Exact_multinomial_test_1xc(1:3, seq(.4, .6, .1), printresults = FALSE), NULL)
  expect_named(Exact_unconditional_test_2x2(n, printresults = FALSE), NULL)
  expect_named(Fisher_exact_test_2x2(n, printresults = FALSE), NULL)
  expect_named(Exact_unconditional_test_2x2(n, printresults = FALSE),  NULL)
  expect_named(Fisher_midP_test_2x2(n, printresults = FALSE), NULL)
  expect_named(FisherFreemanHalton_asymptotic_test_rxc(n, printresults = FALSE), ptdf)
  expect_named(FleissEveritt_test_paired_cxc(n5, printresults = FALSE), ptdf)
  expect_named(FleissLevinPaik_test_paired_cxc(n5, printresults = FALSE), ptdf)
  expect_named(gamma_coefficient_rxc_bca(n, nboot = 200, printresults = FALSE), c("gamma", "L", "U"))
  expect_named(gamma_coefficient_rxc(n, printresults = FALSE), c("gamma", "C", "D"))
  expect_named(Gart_adjusted_logit_CI_2x2(n, printresults = FALSE), lue)
  expect_named(Gold_Wald_CIs_1xc(n, printresults = FALSE), luee)
  expect_named(Goodman_Wald_CIs_1xc(n, printresults = FALSE), luee)
  expect_named(Goodman_Wald_CIs_for_diffs_1xc(n, printresults = FALSE), lue)
  expect_named(Goodman_Wilson_score_CIs_1xc(n, printresults = FALSE), luee)
  expect_named(Independence_smoothed_logit_CI_2x2(n, printresults = FALSE), lue)
  expect_named(Inv_sinh_CI_OR_2x2(n, printresults = FALSE), lue)
  expect_named(Inv_sinh_CI_ratio_2x2(n, printresults = FALSE), lue)
  expect_named(InverseVariance_estimate_stratified_2x2(n4, printresults = FALSE), c("estimate", "psihat", "v"))
  expect_named(Jeffreys_CI_1x2(13, 16, printresults = FALSE), lue)
  expect_named(JonckheereTerpstra_test_rxc(n, printresults = FALSE), pz)
  expect_named(Katz_log_CI_2x2(n, printresults = FALSE), lue)
  expect_named(Kendalls_tau_b_rxc_bca(n, nboot = 200, printresults = FALSE), c("tau_b", "L", "U"))
  expect_named(Kendalls_tau_b_rxc(n, printresults = FALSE), c("tau_b", "L", "U"))
  expect_named(Koopman_asymptotic_score_CI_2x2(n, printresults = FALSE), lue)
  expect_named(KruskalWallis_asymptotic_test_rxc(n, printresults = FALSE), ptdf)
  expect_named(linear_by_linear_test_rxc(n, printresults = FALSE), pz)
  expect_named(LR_CI_1x2(13, 16, printresults = FALSE), lue)
  expect_named(LR_test_1x2(13, 16, .3, printresults = FALSE), psdf)
  expect_named(LR_test_1xc(1:3, c(.3, .5, .1), printresults = FALSE), ptdf)
  expect_named(LR_test_2x2(n, printresults = FALSE), psdf)
  expect_named(MantelHaenszel_estimate_stratified_2x2(n4, printresults = FALSE), c("estimate", "psihat", "w"))
  expect_named(MantelHaenszel_test_2xc(n, printresults = FALSE), ptdf)
  expect_named(McNemar_asymptotic_test_CC_paired_2x2(n, printresults = FALSE), pz)
  expect_named(McNemar_asymptotic_test_paired_2x2(n, printresults = FALSE), pz)
  expect_named(McNemar_exact_cond_test_paired_2x2(n2, printresults = FALSE), NULL)
  expect_named(McNemar_exact_unconditional_test_paired_2x2(n, printresults = FALSE), NULL)
  expect_named(McNemar_midP_test_paired_2x2(n, printresults = FALSE), NULL)
  expect_named(McNemarBowker_test_paired_cxc(n, printresults = FALSE), ptdf)
  expect_named(Mee_asymptotic_score_CI_2x2(n, printresults = FALSE), lue)
  expect_named(MidP_binomial_test_1x2(13, 16, .3, printresults = FALSE), NULL)
  expect_named(MidP_multinomial_test_1xc(n, runif(4), printresults = FALSE), NULL)
  expect_named(MiettinenNurminen_asymptotic_score_CI_difference_2x2(n, printresults = FALSE), lue)
  expect_named(MiettinenNurminen_asymptotic_score_CI_OR_2x2(n, printresults = FALSE), lue)
  expect_named(MiettinenNurminen_asymptotic_score_CI_ratio_2x2(n, printresults = FALSE), lue)
  expect_named(ML_estimates_and_CIs_stratified_2x2(n4, printresults = FALSE), c("alphahat", "alphahatSE", "alphahatCI", "betahat", "betahatSE", "betahatCI", "gammahat", "gammahatSE", "gammahatCI", "pihat"))
  expect_named(MOVER_R_Wilson_CI_OR_2x2(n, printresults = FALSE), lue)
  expect_named(MOVER_R_Wilson_CI_ratio_2x2(n, printresults = FALSE), lue)
  expect_named(MOVER_Wilson_score_CI_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(Newcombe_hybrid_score_CI_2x2(n, printresults = FALSE), lue)
  expect_named(Newcombe_square_and_add_CI_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(Pearson_chi_squared_test_1xc(n, runif(4), printresults = FALSE), ptdf)
  expect_named(Pearson_chi_squared_test_2x2(n, printresults = FALSE), psdf)
  expect_named(Pearson_chi_squared_test_CC_2x2(n, printresults = FALSE), psdf)
  expect_named(Pearson_correlation_coefficient_rxc_bca(n, nboot = 100, printresults = FALSE), rplu)
  expect_named(Pearson_correlation_coefficient_rxc(n, printresults = FALSE), rplu)
  expect_named(Pearson_LR_homogeneity_test_stratified_2x2(n4, printresults = FALSE), plr_df)
  expect_named(Pearson_LR_test_common_effect_stratified_2x2(n4, printresults = FALSE), plr_df)
  expect_named(Pearson_LR_tests_cum_OR_2xc(n, printresults = FALSE), plr)
  expect_named(Pearson_LR_tests_rxc(n, printresults = FALSE), c("T_Pearson", "df_Pearson", "P_Pearson", "T_LR", "df_LR", "P_LR"))
  expect_named(Pearson_LR_tests_unspecific_ordering_rx2(n, "increasing", printresults = FALSE), plr)
  expect_named(Pearson_residuals_rxc(n, printresults = FALSE), c("residuals", "std_residuals"))
  expect_named(Peto_homogeneity_test_stratified_2x2(n4, printresults = FALSE), ptdf)
  expect_named(Peto_OR_estimate_stratified_2x2(n4, printresults = FALSE), c("estimate", "expectation", "variance"))
  expect_named(PriceBonett_approximate_Bayes_CI_2x2(n, printresults = FALSE), lue)
  expect_named(QuesenberryHurst_Wilson_score_CIs_1xc(n, printresults = FALSE), luee)
  expect_named(RBG_test_and_CI_stratified_2x2(n4, printresults = FALSE), c("P", "Z", "L", "U", "thetahatMH", "SElog"))
  expect_named(Scheffe_type_CIs_paired_cxc(n, printresults = FALSE), LUdelta)
  expect_named(Scheffe_type_CIs_rxc(n, printresults = FALSE), LUdiff)
  expect_named(Score_test_1x2(13, 16, .5, printresults = FALSE), ps)
  expect_named(Score_test_and_CI_marginal_mean_scores_paired_cxc(n, runif(4), printresults = FALSE), c("P", "Z_score", "L", "U", "estimate"))
  expect_named(Score_test_CC_1x2(13, 16, .5, printresults = FALSE), ps)
  expect_named(Score_test_for_effect_in_the_probit_model_2xc(n, rnorm(4), printresults = FALSE), ptdf)
  expect_named(Spearman_correlation_coefficient_rxc_bca(n, nboot = 200, printresults = FALSE), c("rho", "L", "U"))
  expect_named(Spearman_correlation_coefficient_rxc(n, printresults = FALSE), c("rho", "L", "U", "L_BW", "U_BW"))
  expect_named(invisible(capture.output(stratified_2x2_tables(n4))), NULL)
  expect_named(Stuart_test_paired_cxc(n2, printresults = FALSE), c("P", "T0", "df"))
  expect_named(Tang_asymptotic_score_CI_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(Tango_asymptotic_score_CI_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(invisible(capture.output(the_1x2_table_CIs(13, 16))), NULL)
  expect_named(invisible(capture.output(the_1x2_table_tests(13, 16, .4))), NULL)
  expect_named(invisible(capture.output(the_1xc_table_CIs(n))), NULL)
  expect_named(invisible(capture.output(the_1xc_table_tests(n, runif(4)))), NULL)
  expect_named(invisible(capture.output(the_2x2_table_CIs_difference(n))), NULL)
  expect_named(invisible(capture.output(the_2x2_table_CIs_OR(n))), NULL)
  expect_named(invisible(capture.output(the_2x2_table_CIs_ratio(n))), NULL)
  expect_named(invisible(capture.output(the_2x2_table_tests(n))), NULL)
  expect_named(invisible(capture.output(the_2xc_table(n7, direction = "decreasing"))), NULL)
  expect_named(invisible(capture.output(the_paired_2x2_table_CIs_difference(n))), NULL)
  expect_named(invisible(capture.output(the_paired_2x2_table_CIs_OR(n))), NULL)
  expect_named(invisible(capture.output(the_paired_2x2_table_CIs_ratio(n))), NULL)
  expect_named(invisible(capture.output(the_paired_2x2_table_tests(n))), NULL)
  expect_named(invisible(capture.output(the_paired_cxc_table_nominal(n))), NULL)
  expect_named(invisible(capture.output(the_paired_cxc_table_ordinal(n, rnorm(4)))), NULL)
  expect_named(invisible(capture.output(the_rx2_table(n2, skip_exact = TRUE))), NULL)
  expect_named(invisible(capture.output(the_rxc_table(n2, nboot = 0))), NULL)
  expect_named(Transformed_Blaker_exact_CI_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(Transformed_Clopper_Pearson_exact_CI_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(Transformed_Clopper_Pearson_midP_CI_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(Transformed_Wilson_score_CI_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(Trend_estimate_CI_tests_rx2(n, 1:2, printresults = FALSE), c("betahat", "Z_Wald", "P_Wald", "T_LR", "P_LR", "df_LR", "chi2", "P_chi2", "df_chi2", "D", "P_D", "df_D", "CI_Wald", "CI_Wald_width"))
  expect_named(Uncorrected_asymptotic_score_CI_2x2(n, printresults = FALSE), lue)
  expect_named(Wald_CI_1x2(13, 16, printresults = FALSE), lue)
  expect_named(Wald_CI_2x2(n, printresults = FALSE), lue)
  expect_named(Wald_CI_AgrestiMin_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(Wald_CI_BonettPrice_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(Wald_CI_CC_1x2(13, 16, printresults = FALSE), lue)
  expect_named(Wald_CI_CC_2x2(n, printresults = FALSE), lue)
  expect_named(Wald_CI_diff_CC_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(Wald_CI_diff_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(Wald_CI_OR_Laplace_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(Wald_CI_OR_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(Wald_CI_ratio_paired_2x2(n, printresults = FALSE), LUe)
  expect_named(Wald_test_1x2(13, 16, .1, printresults = FALSE), ps)
  expect_named(Wald_test_and_CI_common_diff_stratified_2x2(n4, printresults = FALSE), c("P", "Z", "L", "U", "deltahat"))
  expect_named(Wald_test_and_CI_common_ratio_stratified_2x2(n4, printresults = FALSE), c("P", "Z", "L", "U", "phihat"))
  expect_named(Wald_test_and_CI_marginal_mean_ranks_paired_cxc(n, printresults = FALSE), c("tauhat", "SE_tau", "CI_tau", "Z_Wald", "P", "alphahat", "SE_alpha", "CI_alpha", "CI_alpha_logit", "Z_Wald_logit", "P_logit", "CI_tau_logit"))
  expect_named(Wald_test_and_CI_marginal_mean_scores_paired_cxc(n, rnorm(4), printresults = FALSE), c("P", "Z_Wald", LUe))
  expect_named(Wald_test_CC_1x2(13, 16, .1, printresults = FALSE), ps)
  expect_named(Wilson_score_CI_1x2(13, 16, printresults = FALSE), lue)
  expect_named(Wilson_score_CI_CC_1x2(13, 16, printresults = FALSE), lue)
  expect_named(Woolf_logit_CI_2x2(n, printresults = FALSE), lue)
  expect_named(Woolf_test_and_CI_stratified_2x2(n4, printresults = FALSE), c("P", "Z", "L", "U", "thetahatIV"))
  expect_named(Z_unpooled_test_2x2(n, printresults = FALSE), ps)
})
