% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Goodman_Wilson_score_CIs_1xc.R
\name{Goodman_Wilson_score_CIs_1xc}
\alias{Goodman_Wilson_score_CIs_1xc}
\title{The Goodman Wilson score simultaneous intervals for the multinomial probabilities}
\usage{
Goodman_Wilson_score_CIs_1xc(n, alpha = 0.05, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (a 1xc vector, where c is the number of categories)}

\item{alpha}{the nominal level, e.g. 0.05 for 95# CIs}

\item{printresults}{display results (F = no, T = yes)}
}
\value{
A data frame containing lower, upper and point estimates of the statistic
}
\description{
The Goodman Wilson score simultaneous intervals for the multinomial probabilities

(with Bonferroni adjustment)

Described in Chapter 3 "The 1xc Table and the Multinomial Distribution"
}
\examples{
# Genotype counts for SNP rs 6498169 in RA patients
Goodman_Wilson_score_CIs_1xc(n = c(276, 380, 118))
}
