% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Goodman_Wald_CIs_for_diffs_1xc.R
\name{Goodman_Wald_CIs_for_diffs_1xc}
\alias{Goodman_Wald_CIs_for_diffs_1xc}
\title{The Goodman Wald simultaneous intervals for the differences between the}
\usage{
Goodman_Wald_CIs_for_diffs_1xc(n, alpha = 0.05, adjustment = "Bonferroni")
}
\arguments{
\item{n}{the observed counts (a 1xc vector, where c is the number of categories)}

\item{alpha}{the nominal level, e.g. 0.05 for 95# CIs}

\item{adjustment}{Scheffe or Bonferroni adjustment ("Scheffe" or "Bonferroni")}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Goodman Wald simultaneous intervals for the differences between the

multinomial probabilities (with Scheffe or Bonferroni adjustment)

Described in Chapter 3 "The 1xc Table and the Multinomial Distribution"
}
\examples{
Goodman_Wald_CIs_for_diffs_1xc(n = snp6498169$complete$n)
}
