% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/convoSPAT_simulate.R
\name{f_mc_kernels}
\alias{f_mc_kernels}
\title{Calculate mixture component kernel matrices.}
\usage{
f_mc_kernels(y.min = 0, y.max = 5, x.min = 0, x.max = 5, N.mc = 3^2,
  lam1.coef = c(-1.3, 0.5, -0.6), lam2.coef = c(-1.4, -0.1, 0.2),
  logit.eta.coef = c(0, -0.15, 0.15))
}
\arguments{
\item{y.min}{Lower bound for the y-coordinate axis.}

\item{y.max}{Upper bound for the y-coordinate axis.}

\item{x.min}{Lower bound for the y-coordinate axis.}

\item{x.max}{Upper bound for the y-coordinate axis.}

\item{N.mc}{Number of mixture component locations.}

\item{lam1.coef}{Log-linear regression coefficients for lam1; the
coefficients correspond to the intercept, longitude, and latitude.}

\item{lam2.coef}{Log-linear regression coefficients for lam2; the
coefficients correspond to the intercept, longitude, and latitude.}

\item{logit.eta.coef}{Scaled logit regression coefficients for eta; the
coefficients correspond to the intercept, longitude, and latitude.}
}
\value{
A list with the following components:
\item{mc.locations}{A \code{N.mc} x 2 matrix of the mixture component
locations.}
\item{mc.kernels}{A \code{N.mc} x 2 x 2 array of kernel matrices
corresponding to each of the mixture component locations.}
}
\description{
\code{f_mc_kernels} calculates spatially-varying mixture component kernels using
generalized linear models for each of the eigenvalues (lam1 and lam2) and
the angle of rotation (eta).
}
\examples{
f_mc_kernels( y.min = 0, y.max = 5, x.min = 0,
x.max = 5, N.mc = 3^2, lam1.coef = c(-1.3, 0.5, -0.6),
lam2.coef = c(-1.4, -0.1, 0.2), logit.eta.coef = c(0, -0.15, 0.15) )
}

