% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/convoSPAT_summplot.R
\name{plot.NSconvo}
\alias{plot.NSconvo}
\title{Plot from the nonstationary model.}
\usage{
\method{plot}{NSconvo}(x, plot.ellipses = TRUE, fit.radius = NULL,
  aniso.mat = NULL, true.mc = NULL, ref.loc = NULL,
  all.pred.locs = NULL, grid = TRUE, true.col = 1, aniso.col = 4,
  ns.col = 2, plot.mc.locs = TRUE, ...)
}
\arguments{
\item{x}{A "NSconvo" object, from NSconvo_fit().}

\item{plot.ellipses}{Logical; indicates whether the estimated
ellipses should be plotted (\code{TRUE}) or estiamted correlations
(\code{FALSE}).}

\item{fit.radius}{Scalar; defines the fit radius used for the local
likelihood estimation.}

\item{aniso.mat}{2 x 2 matrix; contains the estimated anisotropy
ellipse from the stationary model (for comparison).}

\item{true.mc}{The true mixture component ellipses, if known.}

\item{ref.loc}{Vector of length 2; the reference location.}

\item{all.pred.locs}{A matrix of all prediction locations.}

\item{grid}{Logical; indicates if the \code{all.pred.locs}
are on a rectangular grid (\code{TRUE}) or not (\code{FALSE}).}

\item{true.col}{Color value for the true mixture component ellipses
(if plotted).}

\item{aniso.col}{Color value for the anisotropy ellipse (if
plotted).}

\item{ns.col}{Color value for the mixture component ellipses.}

\item{plot.mc.locs}{Logical; indicates whether the mixture
component locations should be plotted (\code{TRUE}) or not
(\code{FALSE}).}

\item{...}{Other options passed to \code{plot}.}
}
\value{
A plot of either the estimated ellipses or estimated
correlation is printed.
}
\description{
This function plots either the estimated anisotropy ellipses for each
of the mixture component locations or the estimated correlation
between a reference point and all other prediction locations.
}
\examples{
\dontrun{
plot.NSconvo( NSconvo.object )
}
}

