% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extras.R
\name{cmdscale}
\alias{cmdscale}
\title{Wrapper to \code{cmdscale} for S3 class}
\usage{
cmdscale(d, k = 2, eig = TRUE, ...)
}
\arguments{
\item{d}{a distance structure such as that returned by 'dist' or a full symmetric matrix containing the dissimilarities}

\item{k}{the maximum dimension of the space which the data are to be represented in}

\item{eig}{indicates whether eigenvalues should be returned.}

\item{...}{additional parameters passed to cmdscale. See \code{\link{cmdscale}}}
}
\value{
See \code{\link{cmdscale}}. This wrapper only adds an extra slot to the list with the call, adds column labels to the $points and assigns S3 class 'cmdscale'.
}
\description{
Wrapper to \code{cmdscale} for S3 class
}
\examples{
dis<-as.matrix(smacof::kinshipdelta)
res<-cmdscale(dis)
}
