% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_downsize.R
\name{subset_downsize}
\alias{subset_downsize}
\title{subset_downsize}
\usage{
subset_downsize(filename, read_length, overlap, verbose = 1)
}
\arguments{
\item{filename}{A fasta file contains thousands of short reads that have been mapped to a reference. The reference and reads that are not directly mapped to the reference need to be removed after mapping.}

\item{read_length}{An integer (e.g. 250, or 300) giving the read length of your Next-generation Sequencing data. This method is designed for read length >=250bp.}

\item{overlap}{An integer describing number of base pairs of overlap between adjacent subsets. More overlap means more subsets.}

\item{verbose}{Turn on (verbose=1; default) or turn off (verbose=0) the output.}
}
\value{
A number of overlapping subsets (before and after downsizing) of the input alignment.
}
\description{
Subdivides the imported read alignment into subsets and then downsizes each subset by deleting those sequences that have too many gaps or missing data.
}
\examples{
\dontrun{
subset_downsize("inst/extdata/toydata.fasta",300,225,1)
}

}
