% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrastsTest.R
\name{contrastsTest}
\alias{contrastsTest}
\title{Identify differentially-abundant and differentially-variable taxa using contrasts}
\usage{
contrastsTest(
  formula,
  phi.formula,
  contrasts_DA = NULL,
  contrasts_DV = NULL,
  data,
  link = "logit",
  phi.link = "logit",
  sample_data = NULL,
  taxa_are_rows = TRUE,
  filter_discriminant = TRUE,
  fdr_cutoff = 0.05,
  fdr = "fdr",
  inits = NULL,
  try_only = NULL,
  ...
)
}
\arguments{
\item{formula}{an object of class \code{formula} without the response: a symbolic description of the model to be fitted to the abundance}

\item{phi.formula}{an object of class \code{formula} without the response: a symbolic description of the model to be fitted to the dispersion}

\item{contrasts_DA}{List. Optional. Constructs a contrast matrix. List elements should be characters specifying contrasts in the parameters within \code{formula}. Note that this is only available with \code{"Wald"} value for \code{test}. Must include at least one of \code{contrasts_DA} or \code{contrasts_DV}.}

\item{contrasts_DV}{List. Optional. Constructs a contrast matrix. List elements should be characters specifying contrasts in the parameters within \code{phi.formula}. Note that this is only available with \code{"Wald"} value for \code{test}. Must include at least one of \code{contrasts_DA} or \code{contrasts_DV}.}

\item{data}{a data frame containing the OTU table, or \code{phyloseq} object containing the variables in the models}

\item{link}{link function for abundance covariates, defaults to \code{"logit"}}

\item{phi.link}{link function for dispersion covariates, defaults to \code{"logit"}}

\item{sample_data}{Data frame or matrix. Defaults to \code{NULL}. If \code{data} is a data frame or matrix, this must be included as covariates/sample data.}

\item{taxa_are_rows}{Boolean. Optional. If \code{data} is a data frame or matrix, this indicates whether taxa are rows. Defaults to \code{TRUE}.}

\item{filter_discriminant}{Boolean. Defaults to \code{TRUE}. If \code{FALSE}, discriminant taxa will not be filtered out.}

\item{fdr_cutoff}{Integer. Defaults to \code{0.05}. Desired type 1 error rate}

\item{fdr}{Character. Defaults to \code{"fdr"}. False discovery rate control method, see \code{\link{p.adjust}} for more options.}

\item{inits}{Optional initializations for model fit using \code{formula} and \code{phi.formula} as rows of a matrix. Defaults to \code{NULL}.}

\item{try_only}{Optional numeric. Will try only the \code{try_only} taxa, specified either via numeric input or character taxa names. Useful for speed when troubleshooting. Defaults to \code{NULL}, testing all taxa.}

\item{...}{Optional additional arguments for \code{\link{bbdml}}}
}
\value{
An object of class \code{contrastsTest}. List with elements \code{p} containing the p-values for each contrast, \code{p_fdr} containing the p-values after false discovery rate control,  \code{significant_taxa} containing the taxa names of the statistically significant taxa,  \code{contrasts_DA} containing the contrast matrix for parameters associated with the abundance, \code{contrasts_DV} containing the contrast matrix for parameters associated with the dispersion, \code{discriminant_taxa_DA} containing the taxa for which at least one covariate associated with the abundance was perfectly discriminant, \code{discriminant_taxa_DV} containing the taxa for which at least one covariate associated with the dispersion was perfectly discriminant, and \code{data} containing the data used to fit the models.
}
\description{
Identify differentially-abundant and differentially-variable taxa using contrasts
}
\details{
This function uses contrast matrices to test for differential abundance and differential variability using a Wald-type chi-squared test. To use a formula implementation, see \code{\link{differentialTest}}.
}
\examples{

# data frame example
data(soil_phylum_contrasts_sample)
data(soil_phylum_contrasts_otu)
da_analysis <- contrastsTest(formula = ~ DayAmdmt,
                             phi.formula = ~ DayAmdmt,
                             contrasts_DA = list("DayAmdmt21 - DayAmdmt11",
                                                 "DayAmdmt22 - DayAmdmt21"),
                             data = soil_phylum_contrasts_otu,
                             sample_data = soil_phylum_contrasts_sample,
                             fdr_cutoff = 0.05,
                             try_only = 1:5)

# phyloseq example (only run if you have phyloseq installed)
\dontrun{
contrasts_phylo <- phyloseq::phyloseq(phyloseq::sample_data(soil_phylum_contrasts_sample),
phyloseq::otu_table(soil_phylum_contrasts_otu, taxa_are_rows = TRUE))
da_analysis <- contrastsTest(formula = ~ DayAmdmt,
                             phi.formula = ~ DayAmdmt,
                             contrasts_DA = list("DayAmdmt21 - DayAmdmt11",
                                                 "DayAmdmt22 - DayAmdmt21"),
                             data = contrasts_phylo,
                             fdr_cutoff = 0.05,
                             try_only = 1:5)
}

}
