% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refresh_coronavirus.R
\name{refresh_coronavirus_jhu}
\alias{refresh_coronavirus_jhu}
\title{Refresh the 2019 Novel Coronavirus COVID-19 (2019-nCoV) Dataset in the Covid19R Project Format}
\source{
coronavirus - Johns Hopkins University Center for Systems Science and Engineering (JHU CCSE) Coronavirus \href{https://systems.jhu.edu/research/public-health/ncov/}{website}
}
\usage{
refresh_coronavirus_jhu()
}
\value{
A tibble object
* date - The date in YYYY-MM-DD form
* location - The name of the location as provided by the data source.
* location_type - The type of location using the covid19R controlled vocabulary.
* location_code - A standardized location code using a national or international standard. Drawn from \href{https://github.com/olahol/iso-3166-2.js/}{iso-3166-2.js}'s version
* location_code_type The type of standardized location code being used according to the covid19R controlled vocabulary. Here we use `iso_3166_2`
* data_type - the type of data in that given row using the covid19R controlled vocabulary. Includes cases_new, deaths_new, recovered_new.
* value - number of cases of each data type

A data.frame object
}
\description{
Daily summary of the Coronavirus (COVID-19) cases by state/province.
}
\examples{
\dontrun{
# update the data
jhu_covid19_dat <- refresh_coronavirus_jhu()
}

}
