% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation_recipe.cor_test.R,
%   R/visualisation_recipe.easycormatrix.R
\name{visualisation_recipe.easycor_test}
\alias{visualisation_recipe.easycor_test}
\alias{visualisation_recipe.easycormatrix}
\title{Visualisation Recipe for 'correlation' Objects}
\usage{
\method{visualisation_recipe}{easycor_test}(
  x,
  show_data = "point",
  show_text = "subtitle",
  smooth = NULL,
  point = NULL,
  text = NULL,
  labs = NULL,
  ...
)

\method{visualisation_recipe}{easycormatrix}(
  x,
  show_data = "tile",
  show_text = "text",
  tile = NULL,
  point = NULL,
  text = NULL,
  scale_fill = NULL,
  labs = NULL,
  ...
)
}
\arguments{
\item{x}{A correlation object.}

\item{show_data}{Show data. For correlation matrices, can be \code{"tile"} (default) or \code{"point"}.}

\item{show_text}{Show labels with matrix values.}

\item{...}{Other arguments passed to other functions.}

\item{tile, point, text, scale_fill, smooth, labs}{Additional aesthetics and parameters for the geoms (see customization example).}
}
\description{
Visualisation recipe for 'correlation' objects.
}
\examples{
# ==============================================
# Correlation Test
# ==============================================
if (require("see")) {
rez <- cor_test(mtcars, "mpg", "wt")

layers <- visualisation_recipe(rez, labs = list(x = "Miles per Gallon (mpg)"))
layers
plot(layers)

plot(rez,
     show_text = "label",
     point = list(color = "#f44336"),
     text = list(fontface = "bold"),
     show_statistic = FALSE, show_ci = FALSE, stars = TRUE)
}
# ==============================================
# Correlation Matrix
# ==============================================
if (require("see")) {
rez <- correlation(mtcars)

x <- cor_sort(as.matrix(rez))
layers <- visualisation_recipe(x)
layers
plot(layers)

#' Get more details using `summary()`
x <- summary(rez, redundant = TRUE, digits = 3)
plot(visualisation_recipe(x))

# Customize
x <- summary(rez)
layers <- visualisation_recipe(x,
                               show_data = "points",
                               scale = list(range = c(10, 20)),
                               scale_fill = list(high = "#FF5722",
                                                 low = "#673AB7",
                                                 name = "r"),
                               text = list(color = "white"),
                               labs = list(title = "My Plot"))
plot(layers) + theme_modern()
}
}
