% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor-mtest.R
\name{cor.mtest}
\alias{cor.mtest}
\title{Significance test which produces p-values and confidence intervals for each
pair of input features.}
\usage{
cor.mtest(mat, ...)
}
\arguments{
\item{mat}{Input matrix of size \code{FxS}, with \code{F} columns that
represent features and \code{S} rows that represent samples.}

\item{\dots}{Additional arguments passed to function \code{\link{cor.test}},
e.g. \code{conf.level = 0.95}.}
}
\value{
Return a list containing:
  \item{p}{Square matrix of size \code{FxF} with p-values as cells}
  \item{lowCI}{Square matrix of size \code{FxF}, each cell represents the
  \emph{lower part} of a confidence interval}
  \item{uppCI}{Square matrix of size \code{FxF}, each cell represents the
  \emph{upper part} of a confidence interval}
}
\description{
Significance test which produces p-values and confidence intervals for each
pair of input features.
}
\seealso{
Function \code{\link{cor.test}}
}
\keyword{confidence}
\keyword{p-value}
\keyword{significance}
