% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{spline_star_exact}
\alias{spline_star_exact}
\title{Monte Carlo predictive sampler for spline regression}
\usage{
spline_star_exact(
  y,
  tau = NULL,
  transformation = "np",
  y_max = Inf,
  psi = 1000,
  method_sigma = "mle",
  approx_Fz = FALSE,
  approx_Fy = FALSE,
  nsave = 1000,
  compute_marg = TRUE
)
}
\arguments{
\item{y}{\code{n x 1} vector of observed counts}

\item{tau}{\code{n x 1} vector of observation points; if NULL, assume equally-spaced on [0,1]}

\item{transformation}{transformation to use for the latent data; must be one of
\itemize{
\item "identity" (identity transformation)
\item "log" (log transformation)
\item "sqrt" (square root transformation)
\item "bnp" (Bayesian nonparametric transformation using the Bayesian bootstrap)
\item "np" (nonparametric transformation estimated from empirical CDF)
\item "pois" (transformation for moment-matched marginal Poisson CDF)
\item "neg-bin" (transformation for moment-matched marginal Negative Binomial CDF)
}}

\item{y_max}{a fixed and known upper bound for all observations; default is \code{Inf}}

\item{psi}{prior variance (1/smoothing parameter)}

\item{method_sigma}{method to estimate the latent data standard deviation; must be one of
\itemize{
\item "mle" use the MLE from the STAR EM algorithm
\item "mmle" use the marginal MLE (Note: slower!)
}}

\item{approx_Fz}{logical; in BNP transformation, apply a (fast and stable)
normal approximation for the marginal CDF of the latent data}

\item{approx_Fy}{logical; in BNP transformation, approximate
the marginal CDF of \code{y} using the empirical CDF}

\item{nsave}{number of Monte Carlo simulations}

\item{compute_marg}{logical; if TRUE, compute and return the
marginal likelihood}
}
\value{
a list with the following elements:
\itemize{
\item \code{post_ytilde}: \code{nsave x n} samples
from the posterior predictive distribution at the observation points \code{tau}
\item \code{marg_like}: the marginal likelihood (if requested; otherwise NULL)
}
}
\description{
Compute direct Monte Carlo samples from the posterior predictive
distribution of a STAR spline regression model.
}
\details{
STAR defines a count-valued probability model by
(1) specifying a Gaussian model for continuous *latent* data and
(2) connecting the latent data to the observed data via a
*transformation and rounding* operation. Here, the continuous
latent data model is a spline regression.

There are several options for the transformation. First, the transformation
can belong to the *Box-Cox* family, which includes the known transformations
'identity', 'log', and 'sqrt'. Second, the transformation
can be estimated (before model fitting) using the empirical distribution of the
data \code{y}. Options in this case include the empirical cumulative
distribution function (CDF), which is fully nonparametric ('np'), or the parametric
alternatives based on Poisson ('pois') or Negative-Binomial ('neg-bin')
distributions. For the parametric distributions, the parameters of the distribution
are estimated using moments (means and variances) of \code{y}. The distribution-based
transformations approximately preserve the mean and variance of the count data \code{y}
on the latent data scale, which lends interpretability to the model parameters.
Lastly, the transformation can be modeled using the Bayesian bootstrap ('bnp'),
which is a Bayesian nonparametric model and incorporates the uncertainty
about the transformation into posterior and predictive inference.

The Monte Carlo sampler produces direct, discrete, and joint draws
from the posterior predictive distribution of the spline regression model
at the observed tau points.
}
\keyword{internal}
