% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_fit.R
\name{compare_fit}
\alias{compare_fit}
\title{Compare distributions}
\usage{
compare_fit(count_list, fitlist = fit_counts(count_list, model = "all"))
}
\arguments{
\item{count_list}{A \code{list} of counts. Each count should be in separate 
column, rows should represent values of these counts.}

\item{fitlist}{Uses fit_count function to calculate value for each unique 
observation using different
distribution models.}
}
\value{
A \code{data.frame} with distribution values for each unique count. 
Count is the name of the original count, model is the name of distribution 
model, x is unique count value, n is the frequency of unique counts, value 
is result of calculations made by chosen 
distribution model.
}
\description{
Compare empirical distribution of counts with the distribution 
defined by the model fitted to counts.
}
\examples{
df <- data.frame(poisson = rpois(25, 0.3), binomial = rbinom(25, 1, 0.8))
compare_fit(df, fitlist = fit_counts(df, model = "all"))
}
