% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countland_score.R
\name{ScoreGenes}
\alias{ScoreGenes}
\title{Calculate several scores for count-based gene expression.}
\usage{
ScoreGenes(C, subsample = FALSE)
}
\arguments{
\item{C}{countland object}

\item{subsample}{if TRUE, use subsampled counts, otherwise use counts (default=FALSE)}
}
\value{
countland object with slot gene_scores
}
\description{
Calculate several scores for count-based gene expression.
}
\examples{
gold_path <- system.file("testdata", package = "countland", mustWork = TRUE)
gold.data <- Seurat::Read10X(data.dir = gold_path)
C <- countland(gold.data)
C <- ScoreGenes(C)
}
