% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_extraction.R
\name{estimate_extraction}
\alias{estimate_extraction}
\alias{b0}
\alias{b1}
\alias{b}
\alias{f}
\alias{pre}
\alias{p}
\alias{fVal}
\alias{PRE}
\title{Extract estimates/statistics from a model}
\usage{
b0(object, data = NULL)

b1(object, data = NULL)

b(object, data = NULL, all = FALSE, predictor = character())

f(object, data = NULL, all = FALSE, predictor = character(), type = 3)

pre(object, data = NULL, all = FALSE, predictor = character(), type = 3)

p(object, data = NULL, all = FALSE, predictor = character(), type = 3)

fVal(object, data = NULL, all = FALSE, predictor = character(), type = 3)

PRE(object, data = NULL, all = FALSE, predictor = character(), type = 3)
}
\arguments{
\item{object}{A \code{\link{lm}} object, or \code{\link{formula}}.}

\item{data}{If \code{object} is a formula, the data to fit the formula to as a \code{\link{data.frame}}.}

\item{all}{If \code{TRUE}, return a named list of all related terms (e.g. all \emph{F}-values).The name
for the full model value is the name of the function (e.g. "f"), and the names for the
constituent terms are the term names prefixed by the function name (e.g. "f_a:b" for the
\emph{F}-value of the \code{a:b} interaction term).}

\item{predictor}{Filter the output down to just the statistics for these terms (e.g. "hp" to
just get the statistics for that term in the model). This argument is flexible: you can pass
a character vector of terms (\code{c("hp", "hp:cyl")}), a one-sided formula (\code{~hp}), or a list of
formulae (\code{c(~hp, ~hp:cyl)}).}

\item{type}{The type of sums of squares to calculate (see \code{\link[supernova:generate_models]{generate_models()}}). Defaults to the
widely used Type \code{III} SS.}
}
\value{
The value of the estimate as a single number.
}
\description{
This collection of functions is useful for extracting estimates and statistics from a fitted
model. They are particularly useful when estimating many models, like when bootstrapping
confidence intervals. Each function can be used with an already fitted model as an \code{\link{lm}} object,
or a formula and associated data can be passed to it. \strong{All of these assume the comparison is the
empty model.}
}
\details{
\itemize{
\item \strong{\code{b0}}: The intercept from the full model.
\item \strong{\code{b1}}: The slope b1 from the full model.
\item \strong{\code{b}}: The coefficients from the full model.
\item \strong{\code{f}}: The F value from the full model.
\item \strong{\code{pre}}: The Proportional Reduction in Error for the full model.
\item \strong{\code{p}}: The \emph{p}-value from the full model.
\item \strong{\code{sse}}: The SS Error (SS Residual) from the model.
\item \strong{\code{ssm}}: The SS Model (SS Regression) for the full model.
\item \strong{\code{ssr}}: Alias for SSM.
}
}
\examples{
supernova(lm(mpg ~ disp, data = mtcars))
supernova(lm(mpg ~ disp, data = mtcars)) \%>\% print(pcut = 8)
}
\references{
Judd, C. M., McClelland, G. H., & Ryan, C. S. (2017). \emph{Data
Analysis: A Model Comparison Approach to Regression, ANOVA, and Beyond}
(3rd ed.). New York: Routledge. ISBN:879-1138819832
}
