% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fips_to_abbr}
\alias{fips_to_abbr}
\title{Get state abbreviations from FIPS codes}
\usage{
fips_to_abbr(code)
}
\arguments{
\item{code}{Vector of FIPS codes to look up; will match the first two digits
of the code. Note that these are treated as strings; the number
1 will not match "01".}
}
\value{
A vector of state abbreviations.
}
\description{
Look up state abbreviations by FIPS codes (including District of Columbia and
Puerto Rico). Will match the first two digits of the input codes, so should
work for 5-digit county codes, or even longer tract and census block FIPS
codes.
}
\examples{
fips_to_abbr("42000")
fips_to_abbr(c("42", "72", "11"))

}
\seealso{
\code{\link[=abbr_to_fips]{abbr_to_fips()}}
}
