% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/covsep.R
\name{HS_empirical_bootstrap_test}
\alias{HS_empirical_bootstrap_test}
\title{Empirical bootstrap test for
separability of covariance structure using Hilbert--Schmidt distance}
\usage{
HS_empirical_bootstrap_test(Data, B = 100, verbose = FALSE)
}
\arguments{
\item{Data}{a (non-empty) \code{N x d1 x d2} array of data values. The first
direction indices the \eqn{N} observations, each consisting of a \code{d1 x d2}
discretization of the surface, so that \code{Data[i,,]} corresponds to the
i-th observed surface.}

\item{B}{number of bootstrap replicates to be used.}

\item{verbose}{logical parameter for printing progress}
}
\value{
The p-value of the test.
}
\description{
Empirical bootstrap test for
separability of covariance structure using Hilbert--Schmidt distance
}
\section{Details}{


This function performs the test of separability
of the covariance structure for a random surface (introduced in the paper
\url{http://arxiv.org/abs/1505.02023}), when generated from a Gaussian
process. The sample surfaces need to be measured on a common regular grid. The test
considers the Hilbert--Schmidt distance between the sample covariance and its separable approximation.
}
\examples{
data(SurfacesData)
\dontrun{HS_empirical_bootstrap_test(SurfacesData, B = 100)}
}

