% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_grob.R
\name{as_grob}
\alias{as_grob}
\title{Convert a base plot or a ggplot2 plot into a grob}
\usage{
as_grob(plot, device = NULL)
}
\arguments{
\item{plot}{The plot to convert}

\item{device}{A function that creates an appropriate null device. See \code{\link[=set_null_device]{set_null_device()}}
for details. If set to \code{NULL}, will use the cowplot-wide default.}
}
\description{
This function does its best attempt to take whatever you provide it and turn it into a grob.
It is primarily meant to convert ggplot plots into grobs, but it will also take any grid
object (grob), a recorded base R plot, a formula specifying a base R plot, a function that
generates a base R plot, or a trellis object.
}
\examples{
library(grid)
x <- 1:10
y <- (1:10)^2

p <- ~plot(x, y)
grid.newpage()
grid.draw(as_grob(p))
}
