% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrc(MA).R
\name{MA1.data}
\alias{MA1.data}
\title{Most recent changepoints}
\usage{
MA1.data(n = 500, N = 100, K = 5, eps = 1, rho = 0.6, mu = 0,
  siga = 1, rates = c(NA, 0.2), Mrate = 0)
}
\arguments{
\item{n}{length of series, default 500. The size of series(n) should
be greater than 200.}

\item{N}{number of series, default 100.}

\item{K}{number of most recent changepoints, default 5.}

\item{eps}{size of the mean change at the most recent changepoint.}

\item{rho}{ma coefficients}

\item{mu}{mean}

\item{siga}{standard deviation of innovations}

\item{rates}{either a vector of length 2 or a matrix with n rows and 2 columns.
In the vector case, the first element indicates the left-censor rate and
the second element indicates the right-censor rate. Set to NA if there
is no censoring. Interval censored data corresponds to setting both a
left-censor rate and right-censor rate. The default setting indicates
a right-censor rate 0.2 with no left censoring. The vector case handles
single censoring and the matrix case is for multiple censor points.
In this case each column indicates the corresponding censoring for
each observation.}

\item{Mrate}{fraction of missing values. Default is 0}
}
\value{
an object of class 'censored' which is a list with four elements.
First element, 'data', is the censored time series. Second element,
'mrc', indicates the most recent changepoints. Third element, 'series.mrc'
indicates which series is affecting from the most recent changepoint.
Fourth element, 'series.chpts' indicates the changepoints in each series.
}
\description{
Detecting most recent changepoints using censored data generated from MA model.
}
\examples{
#Default example
library(cpcens)
ans<-MA1.data()
#example (right censoring)
# The size of series(n) should be greater than 200.
ans<-MA1.data ( n=500 , N = 100 , K = 5 , eps = 1 , rho=0.2,
mu = 0,  siga = 1, rates = c(NA,0.4), Mrate=0 )
}
