% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpop.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,cpop.class,ANY-method}
\title{Visualisation of Changepoint Locations and Data}
\usage{
\S4method{plot}{cpop.class,ANY}(x)
}
\arguments{
\item{x}{An instance of an cpop S4 class produced by \code{\link{cpop}}.}
}
\value{
A ggplot object.
}
\description{
Plot methods for S4 objects returned by \code{\link{cpop}}.
}
\examples{
library(cpop)

# simulate data with change in gradient
set.seed(1)
x <- (1:50/5)^2
y <- simchangeslope(x,changepoints=c(10,50),change.slope=c(0.25,-0.25),sd=1)

# analyse data
res <- cpop(y,x,beta=2*log(length(y)))

# generate plot object
p <- plot(res)

# visualise
print(p)

}
