% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpop.crops.R
\name{cpop.crops.models}
\alias{cpop.crops.models}
\alias{cpop.crops.models,cpop.crops.class-method}
\title{Extract the cpop models created by cpop.crops}
\usage{
cpop.crops.models(object)
}
\arguments{
\item{object}{An S4 object of type \code{cpop.crops.class} produced by \code{cpop.crops}.}
}
\value{
A list of S4 \code{cpop.class} objects corresponding to the beta values considered by a \code{cpop.crops} analysis.
}
\description{
Obtains a list of models corresponding to each of the beta (penalty) values considered during a \code{cpop.crops} analysis.
}
\examples{
\donttest{
library(cpop)

set.seed(1)
n <- 500
x <- 1:n
m <- 10
mu <- simchangeslope(x,changepoints=(n/(m+1))*0:m,change.slope=c(0.1,0.2*(-1)^(1:m)),sd=0)
epsilon <- rnorm(n+2)
y <- mu+(epsilon[1:n]+epsilon[2:(n+1)]+epsilon[3:(n+2)])/sqrt(3)
res.crops <- cpop.crops(y,x,beta_min=0.5*log(length(y)),beta_max=40*log(length(y)))
models <- cpop.crops.models(res.crops)
for(m in models)
{
  plot(m)
}
}

}
\references{
\insertRef{crops-article}{cpop}

\insertRef{crops-package}{cpop}

\insertRef{cpop-jss-article-2024}{cpop}
}
\seealso{
\code{\link{cpop.crops}},\code{\link[crops]{crops}}
}
