% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register.R
\name{cpp_register}
\alias{cpp_register}
\title{Generates wrappers for registered C++ functions}
\usage{
cpp_register(path = ".", quiet = FALSE)
}
\arguments{
\item{path}{The path to the package root directory}

\item{quiet}{If \code{TRUE} suppresses output from this function}
}
\value{
The paths to the generated R and C++ source files (in that order).
}
\description{
Functions decorated with \verb{[[cpp11::register]]} in files ending in \code{.cc},
\code{.cpp}, \code{.h} or \code{.hpp} will be wrapped in generated code and registered to
be called from R.
}
\details{
Note registered functions will not be \emph{exported} from your package unless
you also add a \verb{@export} roxygen2 directive for them.

In order to use \code{cpp_register()} the \code{cli}, \code{decor}, \code{desc}, \code{glue},
\code{tibble} and \code{vctrs} packages must also be installed.
}
\examples{
# create a minimal package
dir <- tempfile()
dir.create(dir)

writeLines("Package: testPkg", file.path(dir, "DESCRIPTION"))
writeLines("useDynLib(testPkg, .registration = TRUE)", file.path(dir, "NAMESPACE"))

# create a C++ file with a decorated function
dir.create(file.path(dir, "src"))
writeLines("[[cpp11::register]] int one() { return 1; }", file.path(dir, "src", "one.cpp"))

# register the functions in the package
cpp_register(dir)

# Files generated by registration
file.exists(file.path(dir, "R", "cpp11.R"))
file.exists(file.path(dir, "src", "cpp11.cpp"))

# cleanup
unlink(dir, recursive = TRUE)
}
