% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resize.R
\name{resize}
\alias{resize}
\alias{resize,CppSet-method}
\alias{resize,CppUnorderedSet-method}
\alias{resize,CppMultiset-method}
\alias{resize,CppUnorderedMultiset-method}
\alias{resize,CppMap-method}
\alias{resize,CppUnorderedMap-method}
\alias{resize,CppMultimap-method}
\alias{resize,CppUnorderedMultimap-method}
\alias{resize,CppStack-method}
\alias{resize,CppQueue-method}
\alias{resize,CppPriorityQueue-method}
\alias{resize,CppVector-method}
\alias{resize,CppDeque-method}
\alias{resize,CppForwardList-method}
\alias{resize,CppList-method}
\title{Alter the container size}
\usage{
resize(x, size, value = NULL)
}
\arguments{
\item{x}{A \code{cppcontainers} object.}

\item{size}{The new size of the container.}

\item{value}{The value of new elements. It defaults to \code{0} for integers and doubles, to \code{""} for strings, and to \code{FALSE} for booleans.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Alter the size of the container by reference.
}
\details{
If the new size is larger than the former size, the function sets newly added elements in the back to \code{value}.
}
\examples{
v <- cpp_vector(4:9)
v
# 4 5 6 7 8 9

size(v)
# 6

resize(v, 10)
v
# 4 5 6 7 8 9 0 0 0 0

resize(v, 3)
v
# 4 5 6

}
