% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_network.R
\name{build_network.cranly_db}
\alias{build_network.cranly_db}
\alias{cranly_network}
\title{Compute edges and nodes of package directives and collaboration networks}
\usage{
\method{build_network}{cranly_db}(object = clean_CRAN_db(),
  trace = FALSE, perspective = "package", ...)
}
\arguments{
\item{object}{a \code{\link{cranly_db}} object}

\item{trace}{logical. Print progress information? Default is \code{FALSE}}

\item{perspective}{character. Build a \code{"package"} (default )or an \code{"author"} network?}

\item{...}{Currently not used}
}
\value{
A list of 2 \code{\link{data.frame}s} with the \code{edges} and
\code{nodes} of the network
}
\description{
Compute edges and nodes of package directives and collaboration networks
}
\details{
The convention for a \code{\link{cranly_network}} object with
\code{perspective = "package"} is that the direction of an edge is
from the package that is imported by, suggested by, enhances or is
a dependency of another package, to the latter package. The author
collaboration network is analysed and visualised as undirected by
all methods in \code{cranly}.
}
\examples{
\dontrun{
cran_db <- clean_CRAN_db()
## Package directives network
package_network <- build_network(object = cran_db, perspective = "package")
head(package_network$edges)
head(package_network$nodes)
attr(package_network, "timestamp")
class(package_network)

## Author collaboration network
author_network <- build_network(object = cran_db, perspective = "author")
head(author_network$edges)
head(author_network$nodes)
attr(author_network, "timestamp")
class(author_network)
}

}
