% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/expandPred.R
\name{expandPred}
\alias{expandPred}
\title{Expand a time indexed data set with additional prediction times}
\usage{
expandPred(x, Time = "Time", predTime, time.col = FALSE)
}
\arguments{
\item{x}{Data to be expanded.}

\item{Time}{Either a character naming the column which contains original
time values, or a numeric vector of original times}

\item{predTime}{prediction times to expand data}

\item{time.col}{Logical value indicating whether to attach the new times to
the expanded data}
}
\value{
data.frame expanded by \code{predTime}
}
\description{
Expands a covariate data frame (or vector) that has a separate time index by
inserting prediction times and duplicating the covariate values for all
prediction time between subsequent data times.
}
\examples{
#library(crawl)
origTime <- c(1:10)
x <- cbind(rnorm(10), c(21:30))
predTime <- seq(1,10, by=0.25)
expandPred(x, Time=origTime, predTime, time.col=TRUE)
}
\author{
Devin S. Johnson
}

