% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_anaylsis.R
\name{get_bins_table_all}
\alias{get_bins_table_all}
\alias{get_bins_table}
\title{Table of Binning}
\usage{
get_bins_table_all(dat, x_list = NULL, target = NULL,
  pos_flag = NULL, ex_cols = NULL, breaks_list = NULL,
  parallel = FALSE, note = FALSE, occur_time = NULL, oot_pct = 0.7,
  save_data = FALSE, file_name = NULL, dir_path = tempdir())

get_bins_table(dat, x, target = NULL, pos_flag = NULL, breaks = NULL,
  breaks_list = NULL, occur_time = NULL, oot_pct = 0.7,
  note = FALSE)
}
\arguments{
\item{dat}{A data.frame with independent variables and target variable.}

\item{x_list}{Names of independent variables.}

\item{target}{The name of target variable.}

\item{pos_flag}{Value of positive class, Default is "1".}

\item{ex_cols}{A list of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{breaks_list}{A table containing a list of splitting points for each independent variable. Default is NULL.}

\item{parallel}{Logical, parallel computing. Default is FALSE.}

\item{note}{Logical, outputs info. Default is TRUE.}

\item{occur_time}{The name of the variable that represents the time at which each observation takes place.}

\item{oot_pct}{Percentage of observations retained for overtime test (especially to calculate PSI). Defualt is 0.7}

\item{save_data}{Logical, save results in locally specified folder. Default is FALSE.}

\item{file_name}{The name for periodically saved bins table file. Default is "bins_table".}

\item{dir_path}{The path for periodically saved bins table file. Default is "./variable".}

\item{x}{The name of an independent variable.}

\item{breaks}{Splitting points for an independent variable. Default is NULL.}
}
\description{
\code{get_bins_table}  is used to generates summary information of varaibles.
\code{get_bins_table_all} can generates bins table for all specified independent variables.
}
\examples{
breaks_list = get_breaks_all(dat = UCICreditCard, x_list = names(UCICreditCard)[3:4],
target = "default.payment.next.month", equal_bins =TRUE,best = FALSE,g=5,
ex_cols = "ID|apply_date", save_data = FALSE)
get_bins_table_all(dat = UCICreditCard, breaks_list = breaks_list,
target = "default.payment.next.month", occur_time = "apply_date")
}
\seealso{
\code{\link{get_iv}},
\code{\link{get_iv_all}},
\code{\link{get_psi}},
\code{\link{get_psi_all}}
}
