% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{perf_table}
\alias{perf_table}
\alias{ks_plot}
\alias{lift_plot}
\alias{roc_plot}
\alias{psi_plot}
\title{perf_table & plot}
\usage{
perf_table(train_pred, test_pred = NULL, target = NULL, score = NULL,
  g = 10, breaks = NULL, pos_flag = list("1", "1", "Bad", 1),
  total = FALSE)

ks_plot(train_pred, test_pred = NULL, target = NULL, score = NULL,
  gtitle = NULL, breaks = NULL, g = 10)

lift_plot(train_pred, test_pred = NULL, target = NULL, score = NULL,
  gtitle = NULL, breaks = NULL, g = 10)

roc_plot(train_pred, test_pred = NULL, target = NULL, score = NULL,
  gtitle = NULL)

psi_plot(train_pred, test_pred, target = "target", score = "score",
  gtitle = NULL, breaks = NULL, g = 10)
}
\arguments{
\item{train_pred}{A data frame of training with predicted prob or score.}

\item{test_pred}{A data frame of validation with predict prob or score.}

\item{target}{The name of target variable.}

\item{score}{The name of prob or score variable.}

\item{g}{Number of breaks for prob or score.}

\item{breaks}{Splitting points of prob or score.}

\item{pos_flag}{The value of positive class of target variable, default: "1".}

\item{total}{Whether to summarize the table. default: FALSE.}

\item{gtitle}{The title of the graph & The name for periodically saved graphic file.}
}
\description{
\code{perf_table} is for generating a model performance table.
\code{ks_plot} is for K-S.
\code{roc_plot} is for ROC.
\code{lift_plot} is for Lift Chart.
\code{psi_plot} is for PSI.
}
\examples{
sub = cv_split(UCICreditCard, k = 30)[[1]]
dat = UCICreditCard[sub,]
dat = re_name(dat, "default.payment.next.month", "target")
dat = data_cleansing(dat, target = "target", obs_id = "ID",
occur_time = "apply_date", miss_values = list("", -1))

train_test <- train_test_split(dat, split_type = "OOT", prop = 0.7,
                                occur_time = "apply_date")
dat_train = train_test$train
dat_test = train_test$test
x_list = c("PAY_0", "LIMIT_BAL", "PAY_AMT5", "PAY_3", "PAY_2")
Formula = as.formula(paste("target", paste(x_list, collapse = ' + '), sep = ' ~ '))
set.seed(46)
lr_model = glm(Formula, data = dat_train[, c("target", x_list)], family = binomial(logit))

dat_train$pred_LR = round(predict(lr_model, dat_train[, x_list], type = "response"), 5)
dat_test$pred_LR = round(predict(lr_model, dat_test[, x_list], type = "response"), 5)
# model evaluation
perf_table(train_pred = dat_train, test_pred = dat_test, target = "target", score = "pred_LR")
ks_plot(train_pred = dat_train, test_pred = dat_test, target = "target", score = "pred_LR")
roc_plot(train_pred = dat_train, test_pred = dat_test, target = "target", score = "pred_LR")
lift_plot(train_pred = dat_train, test_pred = dat_test, target = "target", score = "pred_LR")
psi_plot(train_pred = dat_train, test_pred = dat_test, target = "target", score = "pred_LR")
}
