test_that("valid abstract cluster launcher object", {
  expect_silent(crew_launcher_cluster())
})

test_that("bad field in cluster launcher object", {
  skip_on_cran()
  x <- crew_launcher_cluster()
  private <- crew_private(x)
  private$.options_cluster$verbose <- 2L
  expect_error(x$validate(), class = "crew_error")
})

test_that("active bindings", {
  x <- crew_launcher_cluster()
  expect_s3_class(x$options_cluster, c("crew_options_cluster", "crew_options"))
})

test_that("SGE subclass mock job creates a tempdir() job script", {
  skip_on_cran()
  skip_on_os("windows")
  x <- crew_launcher_sge(
    options_cluster = crew_options_sge(
      command_submit = "cat",
      command_terminate = "echo",
      script_lines = c("module load R", "echo 'start'"),
      cwd = TRUE,
      envvars = TRUE,
      log_output = "out_dir/",
      log_error = "err_dir/",
      log_join = FALSE,
      memory_gigabytes_required = 2.4,
      memory_gigabytes_limit = 8.4,
      cores = 2L,
      gpu = 1L
    )
  )
  x$start(sockets = "my_socket")
  private <- crew_private(x)
  expect_null(private$.prefix)
  handle <- x$launch_worker(
    call = x$call(
      socket = "my_socket",
      launcher = x$name,
      worker = 1L,
      instance = "instance"
    ),
    name = "my_name",
    launcher = x$name,
    worker = 1L,
    instance = "instance"
  )
  private$.workers$handle[[1L]] <- handle
  expect_false(is.null(private$.prefix))
  script <- path_script(
    dir = tempdir(),
    prefix = private$.prefix,
    launcher = x$name,
    worker = 1L
  )
  expect_equal(handle$name, "my_name")
  expect_equal(handle$script, script)
  expect_true(file.exists(script))
  out <- readLines(script)
  exp <- c(
    "#$ -N my_name",
    "#$ -cwd",
    "#$ -V",
    "#$ -o out_dir/",
    "#$ -e err_dir/",
    "#$ -j n",
    "#$ -l h_rss=8.4G",
    "#$ -l m_mem_free=2.4G",
    "#$ -pe smp 2",
    "#$ -l gpu=1",
    "module load R",
    "echo 'start'"
  )
  expect_equal(out[seq_along(exp)], exp)
  x$terminate_worker(x$workers$handle[[1L]])
  expect_false(file.exists(script))
})

test_that("SGE subclass mock job creates a custom job script", {
  skip_on_cran()
  skip_on_os("windows")
  dir <- file.path(tempfile(), basename(tempfile()), basename(tempfile()))
  x <- crew_launcher_sge(
    crashes_error = 10,
    options_cluster = crew_options_sge(
      command_submit = "cat",
      command_terminate = "echo",
      script_directory = dir,
      script_lines = c("module load R", "echo 'start'"),
      cwd = TRUE,
      envvars = TRUE,
      log_output = "out_dir/",
      log_error = "err_dir/",
      log_join = FALSE,
      memory_gigabytes_required = 2.4,
      memory_gigabytes_limit = 8.4,
      cores = 2L,
      gpu = 1L
    )
  )
  private <- crew_private(x)
  x$start(sockets = "my_socket")
  expect_null(private$.prefix)
  private$.workers$crashes <- 2L
  handle <- x$launch_worker(
    call = x$call(
      socket = "my_socket",
      launcher = x$name,
      worker = 1L,
      instance = "instance"
    ),
    name = "my_name",
    launcher = x$name,
    worker = 1L,
    instance = "instance"
  )
  private$.workers$handle[[1L]] <- handle
  expect_false(is.null(private$.prefix))
  script <- path_script(
    dir = dir,
    prefix = private$.prefix,
    launcher = x$name,
    worker = 1L
  )
  expect_equal(handle$name, "my_name")
  expect_equal(handle$script, script)
  expect_true(file.exists(script))
  out <- readLines(script)
  exp <- c(
    "#$ -N my_name",
    "#$ -cwd",
    "#$ -V",
    "#$ -o out_dir/",
    "#$ -e err_dir/",
    "#$ -j n",
    "#$ -l h_rss=8.4G",
    "#$ -l m_mem_free=2.4G",
    "#$ -pe smp 2",
    "#$ -l gpu=1",
    "module load R",
    "echo 'start'"
  )
  expect_equal(out[seq_along(exp)], exp)
  x$terminate_worker(x$workers$handle[[1L]])
  expect_false(file.exists(script))
})

test_that("SGE subclass mock job prints retry message", {
  skip_on_cran()
  skip_on_os("windows")
  dir <- file.path(tempfile(), basename(tempfile()), basename(tempfile()))
  x <- crew_launcher_sge(
    crashes_error = 10,
    options_cluster = crew_options_sge(
      command_submit = "rm",
      command_terminate = "echo",
      script_directory = dir,
      script_lines = c("module load R", "echo 'start'"),
      cwd = TRUE,
      envvars = TRUE,
      log_output = "out_dir/",
      log_error = "err_dir/",
      log_join = FALSE,
      memory_gigabytes_required = 2.4,
      memory_gigabytes_limit = 8.4,
      cores = 2L,
      gpu = 1L,
      verbose = TRUE
    )
  )
  private <- crew_private(x)
  x$start(sockets = "my_socket")
  private$.workers$crashes <- 2L
  expect_message(
    utils::capture.output(
      handle <- x$launch_worker(
        call = x$call(
          socket = "my_socket",
          launcher = x$name,
          worker = 1L,
          instance = "instance"
        ),
        name = "my_name",
        launcher = x$name,
        worker = 1L,
        instance = "instance"
      )
    ),
    class = "crew_message"
  )
})
