% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_launcher.R
\name{crew_class_launcher}
\alias{crew_class_launcher}
\title{Launcher abstract class}
\description{
\code{R6} abstract class to build other subclasses
which launch and manage workers.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_session_start()
router <- crew_router()
router$start()
launcher <- crew_launcher_local()
launcher$populate(sockets = router$sockets)
launcher$launch()
m <- mirai::mirai("result", .compute = router$name)
Sys.sleep(0.25)
m$data
router$terminate()
crew_session_terminate()
}

## ------------------------------------------------
## Method `crew_class_launcher$new`
## ------------------------------------------------

if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_session_start()
router <- crew_router()
router$start()
launcher <- crew_launcher_local()
launcher$populate(sockets = router$sockets)
launcher$launch()
m <- mirai::mirai("result", .compute = router$name)
Sys.sleep(0.25)
m$data
router$terminate()
crew_session_terminate()
}

## ------------------------------------------------
## Method `crew_class_launcher$call`
## ------------------------------------------------

launcher <- crew_launcher_local()
launcher$call(
  socket = "ws://127.0.0.1:5000/3/cba033e58",
  launcher = "launcher_a",
  worker = 3L,
  instance = "cba033e58"
)
}
\seealso{
Other launchers: 
\code{\link{crew_class_launcher_local}},
\code{\link{crew_launcher_local}()},
\code{\link{crew_launcher}()}
}
\concept{launchers}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{workers}}{Data frame of worker information.}

\item{\code{name}}{Name of the launcher.}

\item{\code{seconds_launch}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_interval}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_timeout}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_idle}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_wall}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_exit}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tasks_max}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tasks_timers}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_globals}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_packages}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_options}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{garbage_collection}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_launcher-new}{\code{crew_class_launcher$new()}}
\item \href{#method-crew_class_launcher-validate}{\code{crew_class_launcher$validate()}}
\item \href{#method-crew_class_launcher-settings}{\code{crew_class_launcher$settings()}}
\item \href{#method-crew_class_launcher-call}{\code{crew_class_launcher$call()}}
\item \href{#method-crew_class_launcher-start}{\code{crew_class_launcher$start()}}
\item \href{#method-crew_class_launcher-launch}{\code{crew_class_launcher$launch()}}
\item \href{#method-crew_class_launcher-expected}{\code{crew_class_launcher$expected()}}
\item \href{#method-crew_class_launcher-launching}{\code{crew_class_launcher$launching()}}
\item \href{#method-crew_class_launcher-terminate}{\code{crew_class_launcher$terminate()}}
\item \href{#method-crew_class_launcher-terminate_worker}{\code{crew_class_launcher$terminate_worker()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-new}{}}}
\subsection{Method \code{new()}}{
Launcher constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$new(
  name = NULL,
  seconds_launch = NULL,
  seconds_interval = NULL,
  seconds_timeout = NULL,
  seconds_idle = NULL,
  seconds_wall = NULL,
  seconds_exit = NULL,
  tasks_max = NULL,
  tasks_timers = NULL,
  reset_globals = NULL,
  reset_packages = NULL,
  reset_options = NULL,
  garbage_collection = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_launch}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_interval}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_timeout}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_idle}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_wall}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_exit}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tasks_max}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tasks_timers}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_globals}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_packages}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_options}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{garbage_collection}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{R6} object with the launcher.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_session_start()
router <- crew_router()
router$start()
launcher <- crew_launcher_local()
launcher$populate(sockets = router$sockets)
launcher$launch()
m <- mirai::mirai("result", .compute = router$name)
Sys.sleep(0.25)
m$data
router$terminate()
crew_session_terminate()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the launcher.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-settings"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-settings}{}}}
\subsection{Method \code{settings()}}{
List of arguments for \code{mirai::server()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$settings(socket)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{socket}}{Character of length 1, websocket address of the worker
to launch.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of arguments for \code{mirai::server()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-call"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-call}{}}}
\subsection{Method \code{call()}}{
Create a call to \code{\link[=crew_worker]{crew_worker()}} to
help create custom launchers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$call(socket, launcher, worker, instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{socket}}{Socket where the worker will receive tasks.}

\item{\code{launcher}}{Character of length 1, name of the launcher.}

\item{\code{worker}}{Positive integer of length 1, index of the worker.
This worker index remains the same even when the current instance
of the worker exits and a new instance launches.}

\item{\code{instance}}{Character of length 1 to uniquely identify
the instance of the worker.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Character of length 1 with a call to \code{\link[=crew_worker]{crew_worker()}}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{launcher <- crew_launcher_local()
launcher$call(
  socket = "ws://127.0.0.1:5000/3/cba033e58",
  launcher = "launcher_a",
  worker = 3L,
  instance = "cba033e58"
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-start"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-start}{}}}
\subsection{Method \code{start()}}{
Start the launcher.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$start(workers = 1L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{workers}}{Positive integer of length 1,
number of workers to allow.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Creates the workers data frame.
Meant to be called once at the beginning of the launcher
life cycle.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-launch"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-launch}{}}}
\subsection{Method \code{launch()}}{
Launch a worker.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$launch(index, socket = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{Positive integer of length 1, index of the worker
to launch.}

\item{\code{socket}}{Character of length 1, sockets of the worker to launch.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-expected"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-expected}{}}}
\subsection{Method \code{expected()}}{
Show which workers are expected to launch.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$expected()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A logical vector indicating which workers are expected
to launch.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-launching"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-launching}{}}}
\subsection{Method \code{launching()}}{
Show whether each worker is launching.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$launching()}\if{html}{\out{</div>}}
}

\subsection{Details}{
A worker is considered "launching" if it was started
recently (\code{seconds_launch} seconds ago or sooner).
}

\subsection{Returns}{
A logical vector indicating which workers are launching.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate one or more workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$terminate(indexes = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{indexes}}{Integer vector of the indexes of the workers
to terminate. If \code{NULL}, all current workers are terminated.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-terminate_worker"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-terminate_worker}{}}}
\subsection{Method \code{terminate_worker()}}{
Abstract method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$terminate_worker(handle)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handle}}{A handle object previously
returned by \code{launch_worker()} which allows the termination
of the worker.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Does not actually terminate a worker. This method is a
placeholder, and its presence allows manual worker termination
to be optional.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
