% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_controller_local.R
\name{crew_controller_local}
\alias{crew_controller_local}
\title{Create a controller with a local process launcher.}
\usage{
crew_controller_local(
  name = NULL,
  workers = 1L,
  host = "127.0.0.1",
  port = NULL,
  tls = crew::crew_tls(),
  tls_enable = NULL,
  tls_config = NULL,
  seconds_interval = 0.5,
  seconds_timeout = 60,
  seconds_launch = 30,
  seconds_idle = Inf,
  seconds_wall = Inf,
  seconds_exit = NULL,
  tasks_max = Inf,
  tasks_timers = 0L,
  reset_globals = TRUE,
  reset_packages = FALSE,
  reset_options = FALSE,
  garbage_collection = FALSE,
  launch_max = 5L
)
}
\arguments{
\item{name}{Name of the client object. If \code{NULL}, a name is automatically
generated.}

\item{workers}{Integer, maximum number of parallel workers to run.}

\item{host}{IP address of the \code{mirai} client to send and receive tasks.
If \code{NULL}, the host defaults to the local IP address.}

\item{port}{TCP port to listen for the workers. If \code{NULL},
then an available ephemeral port is automatically chosen.}

\item{tls}{A TLS configuration object from \code{\link[=crew_tls]{crew_tls()}}.}

\item{tls_enable}{Deprecated on 2023-09-15 in version 0.4.1.
Use argument \code{tls} instead.}

\item{tls_config}{Deprecated on 2023-09-15 in version 0.4.1.
Use argument \code{tls} instead.}

\item{seconds_interval}{Number of seconds between
polling intervals waiting for certain internal
synchronous operations to complete,
such as checking \code{mirai::status()}}

\item{seconds_timeout}{Number of seconds until timing
out while waiting for certain synchronous operations to complete,
such as checking \code{mirai::status()}.}

\item{seconds_launch}{Seconds of startup time to allow.
A worker is unconditionally assumed to be alive
from the moment of its launch until \code{seconds_launch} seconds later.
After \code{seconds_launch} seconds, the worker is only
considered alive if it is actively connected to its assign websocket.}

\item{seconds_idle}{Maximum number of seconds that a worker can idle
since the completion of the last task. If exceeded, the worker exits.
But the timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{idletime} argument of \code{mirai::daemon()}. \code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, so please allow enough idle
time for a new worker to be delegated a new task.}

\item{seconds_wall}{Soft wall time in seconds.
The timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{walltime} argument of \code{mirai::daemon()}.}

\item{seconds_exit}{Deprecated on 2023-09-21 in version 0.5.0.9002.
No longer necessary.}

\item{tasks_max}{Maximum number of tasks that a worker will do before
exiting. See the \code{maxtasks} argument of \code{mirai::daemon()}.
\code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, it is recommended to set
\code{tasks_max} to a value greater than 1.}

\item{tasks_timers}{Number of tasks to do before activating
the timers for \code{seconds_idle} and \code{seconds_wall}.
See the \code{timerstart} argument of \code{mirai::daemon()}.}

\item{reset_globals}{\code{TRUE} to reset global environment
variables between tasks, \code{FALSE} to leave them alone.}

\item{reset_packages}{\code{TRUE} to unload any packages loaded during
a task (runs between each task), \code{FALSE} to leave packages alone.}

\item{reset_options}{\code{TRUE} to reset global options to their original
state between each task, \code{FALSE} otherwise. It is recommended to
only set \code{reset_options = TRUE} if \code{reset_packages} is also \code{TRUE}
because packages sometimes rely on options they set at loading time.}

\item{garbage_collection}{\code{TRUE} to run garbage collection between
tasks, \code{FALSE} to skip.}

\item{launch_max}{Positive integer of length 1, maximum allowed
consecutive launch attempts which do not complete any tasks.
Enforced on a worker-by-worker basis.
The futile launch count resets to back 0
for each worker that completes a task.
It is recommended to set \code{launch_max} above 0
because sometimes workers are unproductive under perfectly ordinary
circumstances. But \code{launch_max} should still be small enough
to detect errors in the underlying platform.}
}
\description{
Create an \code{R6} object to submit tasks and
launch workers on local processes.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
controller <- crew_controller_local()
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()
controller$terminate()
}
}
\seealso{
Other plugin_local: 
\code{\link{crew_class_launcher_local}},
\code{\link{crew_launcher_local}()}
}
\concept{plugin_local}
