% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/caseUtils.R
\name{fixDateTime}
\alias{fixDateTime}
\title{Updates criminal incident data with date-time objects in correct format.}
\usage{
fixDateTime(crimedata, tz = "")
}
\arguments{
\item{crimedata}{(n x p) data frame of crimes containing the fields:
  DATE_FROM, DATE_TO, TIME_FROM, TIME_TO
\itemize{
            \item times must be in format: \code{\%H\%M}
            \item dates must be in format: \code{\%Y-\%m-\%d}
            }}

\item{tz}{timezone}
}
\value{
This function returns an updated \code{crimedata} data frame by adding
   the fields: DT.FROM, DT.TO and deleting the fields:
   DATE_FROM, DATE_TO, TIME_FROM, TIME_TO.
}
\description{
Convenience function to update crime data that has separate date and time
  fields with date-time fields
}
\details{
See \code{\link{getDateTime}} for details.
}
\seealso{
\code{\link{getDateTime}}
}

