% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/caseUtils.R
\name{getCriminals}
\alias{getCriminals}
\title{Lookup the offenders responsible for a set of solved crimes}
\usage{
getCriminals(crimeID, offenderTable)
}
\arguments{
\item{crimeID}{crimeID(s) of solved crimes.}

\item{offenderTable}{offender table that indicates the offender(s) responsible
  for solved crimes. \code{offenderTable} must have columns named:
  \code{offenderID} and \code{crimeID}.}
}
\value{
Vector of offenderIDs responsible for crimes labeled \code{crimeID}.
}
\description{
Generates the IDs of criminals responsible for a set of solved crimes using
the information in \code{offenderTable}.
}
\examples{
data(offenders)

 getCriminals("C:1",offenders)

 getCriminals("C:78",offenders)                      # shows co-offenders

 getCriminals(c("C:26","C:78","85","110"),offenders) # all offenders from a crime series
}
\seealso{
\code{\link{getCrimeSeries}}
}

