% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/compareCrimes.R
\name{compareCrimes}
\alias{compareCrimes}
\title{Creates evidence variables by calculating \sQuote{distance} between crime pairs}
\usage{
compareCrimes(Pairs, crimedata, varlist, binary = TRUE, longlat = FALSE,
  show.pb = FALSE, ...)
}
\arguments{
\item{Pairs}{(n x 2) matrix of crimeIDs}

\item{crimedata}{data.frame of crime incident data. There must be a column
 named \code{crimedata} that refers to the crimeIDs given in \code{Pairs}.
 Other column names must correspond to what is given in \code{varlist} list.}

\item{varlist}{a list with elements named: crimeID, spatial, temporal,
  categorical, and numerical. Each element should be a vector of the column
  names of \code{crimedata} corresponding to that feature:
 \itemize{
  \item crimeID: crime ID for the crimedata that is matched to \code{Pairs}
  \item spatial: X,Y coordinates (in long,lat or Cartesian) of crimes
  \item temporal: DT.FROM, DT.TO of crimes. If times are uncensored, then
   only DT.FROM needs to be provided.
  \item categorical: (optional) categorical crime variables
  \item numerical: (optional) numerical crime variables
 }}

\item{binary}{(logical) match/no match or all combinations for categorical
  data}

\item{longlat}{(logical) are spatial coordinates in (long,lat)?}

\item{show.pb}{(logical) show the progress bar}

\item{\ldots}{other arguments passed to hidden functions}
}
\value{
data.frame of various proximity measures between the two crimes
 \itemize{
  \item If \code{spatial} data is provided: the euclidean distance
  (if \code{longlat = FALSE}) or Haversine great circle distance
  (\code{\link[geosphere]{distHaversine}} if \code{longlat = TRUE}) is
  returned (in kilometers).

  \item If \code{temporal} data is provided: the expected absolute time
   difference is returned:
   \itemize{
     \item temporal - overall difference (in days)  [0,max]
     \item tod - time of day difference (in hours)  [0,12]
     \item dow - fractional day of week difference (in days) [0,3.5]
   }

  \item If \code{categorical} data is provided: if \code{binary = TRUE} then a
   1 if the categories of each crime match and a 0 if they do not match. If
   \code{binary = FALSE}, then a factor of merged values (in form of f1:f2)

  \item If \code{numerical} data is provided: the absolute difference is
   returned.
 }
}
\description{
Calculates spatial and temporal distance, difference in categorical, and
  absolute value of numerical crime variables
}
\examples{
data(crimes)
 pairs = t(combn(crimes$crimeID[1:4],m=2))   # make some crime pairs

 varlist = list(
   spatial = c("X", "Y"),
   temporal = c("DT.FROM","DT.TO"),
   categorical = c("MO1",  "MO2", "MO3"))    # crime variables list

 compareCrimes(pairs,crimes,varlist,binary=TRUE)
}
\references{
Porter, M. D. (2014). A Statistical Approach to Crime Linkage.
   \emph{arXiv preprint arXiv:1410.2285.}.
 \url{http://arxiv.org/abs/1410.2285}
}

