% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{make_mean_std_dev_by_group_table}
\alias{make_mean_std_dev_by_group_table}
\title{Get mean and standard deviation of variables by group}
\usage{
make_mean_std_dev_by_group_table(data, group_column, columns, total_row = TRUE)
}
\arguments{
\item{data}{A data.frame with the data you want to make the table from.}

\item{group_column}{A string with the name of the variable you are grouping by}

\item{columns}{A string or vector of strings for the variables you want to get the mean
and standard deviation for.}

\item{total_row}{A boolean (default TRUE) for whether to include a row a the bottom for the
overall mean and standard deviation (i.e. not by group).}
}
\value{
A data.frame with the first column showing the category grouped by. Then
one column for each variable you want the mean and standard deviation for.
Will give the mean and standard deviation as a single string with the
standard deviation in parentheses.
}
\description{
Get mean and standard deviation of variables by group
}
\examples{
make_mean_std_dev_by_group_table(mtcars, "gear", c("mpg", "disp"))
}
