% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{Sample}
\alias{Sample}
\title{Sample Function}
\usage{
Sample(
  bn,
  code = "mcnp",
  cores = parallel::detectCores()/2,
  keff.cutoff = 0.9,
  metamodel,
  sample.size = 1e+09,
  ext.dir,
  risk.dir = NULL
)
}
\arguments{
\item{bn}{Bayesian network object}

\item{code}{Monte Carlo radiation transport code (e.g., "cog", "mcnp")}

\item{cores}{Number of CPU cores to use for generating Bayesian network samples}

\item{keff.cutoff}{keff cutoff value (e.g., 0.9)}

\item{metamodel}{List of deep neural network metamodels and weights}

\item{sample.size}{Number of samples used to calculate risk}

\item{ext.dir}{External directory (full path)}

\item{risk.dir}{Risk directory}
}
\value{
A list of Bayesian network samples with predicted keff values
}
\description{
This function samples the Bayesian network and generates keff predictions using a deep neural network metamodel.
}
