% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{h_test_named_numeric}
\alias{h_test_named_numeric}
\title{Check that an argument is a named vector of type numeric}
\usage{
h_test_named_numeric(
  x,
  subset.of = NULL,
  must.include = NULL,
  permutation.of = NULL,
  identical.to = NULL,
  disjunct.from = NULL,
  lower = 0 + .Machine$double.xmin,
  finite = TRUE,
  any.missing = FALSE,
  len = 2,
  ...
)
}
\arguments{
\item{x}{(\code{any})\cr object to check.}

\item{subset.of}{[\code{character}]\cr
Names provided in \code{x} must be subset of the set \code{subset.of}.}

\item{must.include}{[\code{character}]\cr
Names provided in \code{x} must be a superset of the set \code{must.include}.}

\item{permutation.of}{[\code{character}]\cr
Names provided in \code{x} must be a permutation of the set \code{permutation.of}.
Duplicated names in \code{permutation.of} are stripped out and duplicated names in \code{x}
thus lead to a failed check.
Use this argument instead of \code{identical.to} if the order of the names is not relevant.}

\item{identical.to}{[\code{character}]\cr
Names provided in \code{x} must be identical to the vector \code{identical.to}.
Use this argument instead of \code{permutation.of} if the order of the names is relevant.}

\item{disjunct.from}{[\code{character}]\cr
Names provided in \code{x} must may not be present in the vector \code{disjunct.from}.}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than or equal to.}

\item{finite}{[\code{logical(1)}]\cr
Check for only finite values? Default is \code{FALSE}.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{...}{further parameters passed to \code{\link[checkmate:checkNumeric]{checkmate::test_numeric()}}.}
}
\value{
\code{TRUE} if \code{x} is a named vector of type numeric, otherwise \code{FALSE}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A simple helper function that tests whether an object is a named numerical
vector.
}
\note{
This function is based on \code{\link[checkmate:checkNumeric]{checkmate::test_numeric()}} and
\code{\link[checkmate:checkNames]{checkmate::test_names()}} functions.
}
\examples{
h_test_named_numeric(1:2, permutation.of = c("a", "b"))
h_test_named_numeric(c(a = 1, b = 2), permutation.of = c("a", "b"))
h_test_named_numeric(c(a = 1, b = 2), permutation.of = c("b", "a"))
}
